"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractRuleDataSource = void 0;
var _diffable_field_types = require("../../../../../../../common/detection_engine/prebuilt_rules/model/diff/diffable_rule/diffable_field_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractRuleDataSource = (indexPatterns, dataViewId) => {
  if (indexPatterns != null) {
    return {
      type: _diffable_field_types.DataSourceType.index_patterns,
      index_patterns: indexPatterns
    };
  }
  if (dataViewId != null) {
    return {
      type: _diffable_field_types.DataSourceType.data_view,
      data_view_id: dataViewId
    };
  }
  return undefined;
};
exports.extractRuleDataSource = extractRuleDataSource;