"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelinePinnedEventActionsType = exports.epicPersistPinnedEvent = exports.createTimelinePinnedEventEpic = void 0;
var _fp = require("lodash/fp");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _actions = require("../../../common/store/app/actions");
var _actions2 = require("./actions");
var _my_epic_timeline_id = require("./my_epic_timeline_id");
var _epic_dispatcher_timeline_persistence_queue = require("./epic_dispatcher_timeline_persistence_queue");
var _api = require("../../containers/pinned_event/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelinePinnedEventActionsType = [_actions2.pinEvent.type, _actions2.unPinEvent.type];
exports.timelinePinnedEventActionsType = timelinePinnedEventActionsType;
const epicPersistPinnedEvent = (action, timeline, action$, timeline$, allTimelineQuery$) => (0, _rxjs.from)((0, _api.persistPinnedEvent)({
  pinnedEventId: timeline[action.payload.id].pinnedEventsSaveObject[action.payload.eventId] != null ? timeline[action.payload.id].pinnedEventsSaveObject[action.payload.eventId].pinnedEventId : null,
  eventId: action.payload.eventId,
  timelineId: _my_epic_timeline_id.myEpicTimelineId.getTimelineId()
})).pipe((0, _operators.withLatestFrom)(timeline$, allTimelineQuery$), (0, _operators.mergeMap)(([result, recentTimeline, allTimelineQuery]) => {
  const savedTimeline = recentTimeline[action.payload.id];
  const response = (0, _fp.get)('data.persistPinnedEventOnTimeline', result);
  const callOutMsg = response && response.code === 403 ? [(0, _actions2.showCallOutUnauthorizedMsg)()] : [];
  if (allTimelineQuery.refetch != null) {
    allTimelineQuery.refetch();
  }
  return [response != null ? (0, _actions2.updateTimeline)({
    id: action.payload.id,
    timeline: {
      ...savedTimeline,
      savedObjectId: savedTimeline.savedObjectId == null && response.timelineId != null ? response.timelineId : savedTimeline.savedObjectId,
      version: savedTimeline.version == null && response.timelineVersion != null ? response.timelineVersion : savedTimeline.version,
      pinnedEventIds: {
        ...savedTimeline.pinnedEventIds,
        [action.payload.eventId]: true
      },
      pinnedEventsSaveObject: {
        ...savedTimeline.pinnedEventsSaveObject,
        [action.payload.eventId]: response
      }
    }
  }) : (0, _actions2.updateTimeline)({
    id: action.payload.id,
    timeline: {
      ...savedTimeline,
      pinnedEventIds: (0, _fp.omit)(action.payload.eventId, savedTimeline.pinnedEventIds),
      pinnedEventsSaveObject: (0, _fp.omit)(action.payload.eventId, savedTimeline.pinnedEventsSaveObject)
    }
  }), ...callOutMsg, (0, _actions2.endTimelineSaving)({
    id: action.payload.id
  })];
}), (0, _operators.startWith)((0, _actions2.startTimelineSaving)({
  id: action.payload.id
})), (0, _operators.takeUntil)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([checkAction, updatedTimeline]) => {
  if (checkAction.type === _actions.addError.type) {
    return true;
  }
  if (checkAction.type === _actions2.endTimelineSaving.type && updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId != null) {
    _my_epic_timeline_id.myEpicTimelineId.setTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId);
    _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].version);
    return true;
  }
  return false;
}))));
exports.epicPersistPinnedEvent = epicPersistPinnedEvent;
const createTimelinePinnedEventEpic = () => action$ => action$.pipe((0, _operators.filter)(action => timelinePinnedEventActionsType.includes(action.type)), (0, _operators.mergeMap)(action => {
  _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.next({
    action
  });
  return (0, _rxjs.empty)();
}));
exports.createTimelinePinnedEventEpic = createTimelinePinnedEventEpic;