"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineFavoriteActionsType = exports.epicPersistTimelineFavorite = exports.createTimelineFavoriteEpic = void 0;
var _fp = require("lodash/fp");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _actions = require("../../../common/store/app/actions");
var _actions2 = require("./actions");
var _epic_dispatcher_timeline_persistence_queue = require("./epic_dispatcher_timeline_persistence_queue");
var _my_epic_timeline_id = require("./my_epic_timeline_id");
var _api = require("../../../../common/types/timeline/api");
var _api2 = require("../../containers/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineFavoriteActionsType = [_actions2.updateIsFavorite.type];
exports.timelineFavoriteActionsType = timelineFavoriteActionsType;
const epicPersistTimelineFavorite = (action, timeline, action$, timeline$, allTimelineQuery$) => {
  var _timeline$action$payl;
  return (0, _rxjs.from)((0, _api2.persistFavorite)({
    timelineId: _my_epic_timeline_id.myEpicTimelineId.getTimelineId(),
    templateTimelineId: timeline[action.payload.id].templateTimelineId,
    templateTimelineVersion: timeline[action.payload.id].templateTimelineVersion,
    timelineType: (_timeline$action$payl = timeline[action.payload.id].timelineType) !== null && _timeline$action$payl !== void 0 ? _timeline$action$payl : _api.TimelineType.default
  })).pipe((0, _operators.withLatestFrom)(timeline$, allTimelineQuery$), (0, _operators.mergeMap)(([result, recentTimelines, allTimelineQuery]) => {
    const savedTimeline = recentTimelines[action.payload.id];
    const response = (0, _fp.get)('data.persistFavorite', result);
    const callOutMsg = response.code === 403 ? [(0, _actions2.showCallOutUnauthorizedMsg)()] : [];
    if (allTimelineQuery.refetch != null) {
      allTimelineQuery.refetch();
    }
    return [...callOutMsg, (0, _actions2.updateTimeline)({
      id: action.payload.id,
      timeline: {
        ...savedTimeline,
        isFavorite: response.favorite != null && response.favorite.length > 0,
        savedObjectId: response.savedObjectId || null,
        version: response.version || null
      }
    }), (0, _actions2.endTimelineSaving)({
      id: action.payload.id
    })];
  }), (0, _operators.startWith)((0, _actions2.startTimelineSaving)({
    id: action.payload.id
  })), (0, _operators.takeUntil)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([checkAction, updatedTimeline]) => {
    if (checkAction.type === _actions.addError.type) {
      return true;
    }
    if (checkAction.type === _actions2.endTimelineSaving.type && updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId != null) {
      _my_epic_timeline_id.myEpicTimelineId.setTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].version);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].templateTimelineId);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].templateTimelineVersion);
      return true;
    }
    return false;
  }))));
};
exports.epicPersistTimelineFavorite = epicPersistTimelineFavorite;
const createTimelineFavoriteEpic = () => action$ => {
  return action$.pipe((0, _operators.filter)(action => timelineFavoriteActionsType.includes(action.type)), (0, _operators.mergeMap)(action => {
    _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.next({
      action
    });
    return (0, _rxjs.empty)();
  }));
};
exports.createTimelineFavoriteEpic = createTimelineFavoriteEpic;