"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
  Duplicated EuiSuperSelect, because due to the recent changes there is no way to pass panelClassName
  prop to EuiInputPopover, which doesn't allow us to properly style the EuiInputPopover panel
  (we want the panel to be wider than the input)
*/
var ShiftDirection;
(function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
})(ShiftDirection || (ShiftDirection = {}));
class EuiSuperSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "itemNodes", []);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: this.props.isOpen || false
    });
    (0, _defineProperty2.default)(this, "setItemNode", (node, index) => {
      this.itemNodes[index] = node;
    });
    (0, _defineProperty2.default)(this, "openPopover", () => {
      this.setState({
        isPopoverOpen: true
      });
      const focusSelected = () => {
        const indexOfSelected = this.props.options.reduce((acc, option, index) => {
          if (acc != null) return acc;
          if (option == null) return null;
          return option.value === this.props.valueOfSelected ? index : null;
        }, null);
        requestAnimationFrame(() => {
          if (!this._isMounted) {
            return;
          }
          if (this.props.valueOfSelected != null) {
            if (indexOfSelected != null) {
              this.focusItemAt(indexOfSelected);
            } else {
              focusSelected();
            }
          }
        });
      };
      requestAnimationFrame(focusSelected);
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "itemClicked", value => {
      this.setState({
        isPopoverOpen: false
      });
      if (this.props.onChange) {
        this.props.onChange(value);
      }
    });
    (0, _defineProperty2.default)(this, "onSelectKeyDown", event => {
      if (event.key === _eui.keys.ARROW_UP || event.key === _eui.keys.ARROW_DOWN) {
        event.preventDefault();
        event.stopPropagation();
        this.openPopover();
      }
    });
    (0, _defineProperty2.default)(this, "onItemKeyDown", event => {
      switch (event.key) {
        case _eui.keys.ESCAPE:
          // close the popover and prevent ancestors from handling
          event.preventDefault();
          event.stopPropagation();
          this.closePopover();
          break;
        case _eui.keys.TAB:
          // no-op
          event.preventDefault();
          event.stopPropagation();
          break;
        case _eui.keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();
          this.shiftFocus(ShiftDirection.BACK);
          break;
        case _eui.keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();
          this.shiftFocus(ShiftDirection.FORWARD);
          break;
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
    if (this.props.isOpen) {
      this.openPopover();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  focusItemAt(index) {
    const targetElement = this.itemNodes[index];
    if (targetElement != null) {
      targetElement.focus();
    }
  }
  shiftFocus(direction) {
    const currentIndex = this.itemNodes.indexOf(document.activeElement);
    let targetElementIndex;
    if (currentIndex === -1) {
      // somehow the select options has lost focus
      targetElementIndex = 0;
    } else {
      if (direction === ShiftDirection.BACK) {
        targetElementIndex = currentIndex === 0 ? this.itemNodes.length - 1 : currentIndex - 1;
      } else {
        targetElementIndex = currentIndex === this.itemNodes.length - 1 ? 0 : currentIndex + 1;
      }
    }
    this.focusItemAt(targetElementIndex);
  }
  render() {
    const {
      className,
      options,
      valueOfSelected,
      onChange,
      isOpen,
      isInvalid,
      hasDividers,
      itemClassName,
      itemLayoutAlign,
      fullWidth,
      popoverProps,
      compressed,
      ...rest
    } = this.props;
    const popoverClasses = (0, _classnames.default)('euiSuperSelect', popoverProps === null || popoverProps === void 0 ? void 0 : popoverProps.className);
    const buttonClasses = (0, _classnames.default)({
      'euiSuperSelect--isOpen__button': this.state.isPopoverOpen
    }, className);
    const itemClasses = (0, _classnames.default)('euiSuperSelect__item', {
      'euiSuperSelect__item--hasDividers': hasDividers
    }, itemClassName);
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelectControl, (0, _extends2.default)({
      options: options,
      value: valueOfSelected,
      onClick: this.state.isPopoverOpen ? this.closePopover : this.openPopover,
      onKeyDown: this.onSelectKeyDown,
      className: buttonClasses,
      fullWidth: fullWidth,
      isInvalid: isInvalid,
      compressed: compressed
    }, rest));
    const items = options.map((option, index) => {
      const {
        value,
        dropdownDisplay,
        inputDisplay,
        ...optionRest
      } = option;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
        key: index,
        className: itemClasses,
        icon: valueOfSelected === value ? 'check' : 'empty',
        onClick: () => this.itemClicked(value),
        onKeyDown: this.onItemKeyDown,
        layoutAlign: itemLayoutAlign,
        buttonRef: node => this.setItemNode(node, index),
        role: "option",
        id: value,
        "aria-selected": valueOfSelected === value
      }, optionRest), dropdownDisplay || inputDisplay);
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, (0, _extends2.default)({}, popoverProps, {
      className: popoverClasses,
      input: button,
      isOpen: isOpen || this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      panelClassName: popoverClasses,
      fullWidth: fullWidth,
      repositionOnScroll: true,
      anchorPosition: "downCenter"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
      role: "alert"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
      token: "euiSuperSelect.screenReaderAnnouncement",
      default: "You are in a form selector of {optionsCount} items and must select a single option. Use the up and down keys to navigate or escape to close.",
      values: {
        optionsCount: options.length
      }
    }))), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiSuperSelect__listbox",
      role: "listbox",
      "aria-activedescendant": valueOfSelected,
      tabIndex: 0
    }, items));
  }
}
exports.EuiSuperSelect = EuiSuperSelect;
(0, _defineProperty2.default)(EuiSuperSelect, "defaultProps", {
  compressed: false,
  fullWidth: false,
  hasDividers: false,
  isInvalid: false,
  isLoading: false
});