"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connector = exports.StatefulSearchOrFilter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _store = require("../../../../common/store");
var _timeline = require("../../../store/timeline");
var _defaults = require("../../../store/timeline/defaults");
var _super_date_picker = require("../../../../common/components/super_date_picker");
var _search_or_filter = require("./search_or_filter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatefulSearchOrFilterComponent = /*#__PURE__*/_react.default.memo(({
  dataProviders,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  isRefreshPaused,
  kqlMode,
  refreshInterval,
  savedQueryId,
  setFilters,
  setSavedQueryId,
  timelineId,
  to,
  toStr,
  updateKqlMode,
  updateReduxTime
}) => {
  const setFiltersInTimeline = (0, _react.useCallback)(newFilters => setFilters({
    id: timelineId,
    filters: newFilters
  }), [timelineId, setFilters]);
  const setSavedQueryInTimeline = (0, _react.useCallback)(newSavedQueryId => setSavedQueryId({
    id: timelineId,
    savedQueryId: newSavedQueryId
  }), [timelineId, setSavedQueryId]);
  return /*#__PURE__*/_react.default.createElement(_search_or_filter.SearchOrFilter, {
    dataProviders: dataProviders,
    filters: filters,
    filterManager: filterManager,
    filterQuery: filterQuery,
    from: from,
    fromStr: fromStr,
    isRefreshPaused: isRefreshPaused,
    kqlMode: kqlMode,
    refreshInterval: refreshInterval,
    savedQueryId: savedQueryId,
    setFilters: setFiltersInTimeline,
    setSavedQueryId: setSavedQueryInTimeline,
    timelineId: timelineId,
    to: to,
    toStr: toStr,
    updateKqlMode: updateKqlMode,
    updateReduxTime: updateReduxTime
  });
}, (prevProps, nextProps) => {
  return prevProps.filterManager === nextProps.filterManager && prevProps.from === nextProps.from && prevProps.fromStr === nextProps.fromStr && prevProps.to === nextProps.to && prevProps.toStr === nextProps.toStr && prevProps.isRefreshPaused === nextProps.isRefreshPaused && prevProps.refreshInterval === nextProps.refreshInterval && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.dataProviders, nextProps.dataProviders) && (0, _fastDeepEqual.default)(prevProps.filters, nextProps.filters) && (0, _fastDeepEqual.default)(prevProps.filterQuery, nextProps.filterQuery) && (0, _fastDeepEqual.default)(prevProps.kqlMode, nextProps.kqlMode) && (0, _fastDeepEqual.default)(prevProps.savedQueryId, nextProps.savedQueryId) && (0, _fastDeepEqual.default)(prevProps.timelineId, nextProps.timelineId);
});
StatefulSearchOrFilterComponent.displayName = 'StatefulSearchOrFilterComponent';
const makeMapStateToProps = () => {
  const getTimeline = _timeline.timelineSelectors.getTimelineByIdSelector();
  const getKqlFilterQuery = _timeline.timelineSelectors.getKqlFilterKuerySelector();
  const getInputsTimeline = _store.inputsSelectors.getTimelineSelector();
  const getInputsPolicy = _store.inputsSelectors.getTimelinePolicySelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const policy = getInputsPolicy(state);
    return {
      dataProviders: timeline.dataProviders,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      filterQuery: getKqlFilterQuery(state, timelineId),
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      filters: timeline.filters,
      from: input.timerange.from,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      fromStr: input.timerange.fromStr,
      isRefreshPaused: policy.kind === 'manual',
      kqlMode: (0, _fp.getOr)('filter', 'kqlMode', timeline),
      refreshInterval: policy.duration,
      savedQueryId: (0, _fp.getOr)(null, 'savedQueryId', timeline),
      to: input.timerange.to,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      toStr: input.timerange.toStr
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = dispatch => ({
  applyKqlFilterQuery: ({
    id,
    filterQuery
  }) => dispatch(_timeline.timelineActions.applyKqlFilterQuery({
    id,
    filterQuery
  })),
  updateKqlMode: ({
    id,
    kqlMode
  }) => dispatch(_timeline.timelineActions.updateKqlMode({
    id,
    kqlMode
  })),
  setSavedQueryId: ({
    id,
    savedQueryId
  }) => dispatch(_timeline.timelineActions.setSavedQueryId({
    id,
    savedQueryId
  })),
  setFilters: ({
    id,
    filters
  }) => dispatch(_timeline.timelineActions.setFilters({
    id,
    filters
  })),
  updateReduxTime: (0, _super_date_picker.dispatchUpdateReduxTime)(dispatch)
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
exports.connector = connector;
const StatefulSearchOrFilter = connector(StatefulSearchOrFilterComponent);
exports.StatefulSearchOrFilter = StatefulSearchOrFilter;