"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTitleAndDescription = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _shared_imports = require("../../../../shared_imports");
var _timeline = require("../../../../../common/types/timeline");
var _api = require("../../../../../common/types/timeline/api");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline2 = require("../../../store/timeline");
var _notes_size = require("../properties/notes_size");
var _use_create_timeline = require("../properties/use_create_timeline");
var commonI18n = _interopRequireWildcard(require("../properties/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _schema = require("./schema");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
// when showWarning equals to true,
// the modal is used as a reminder for users to save / discard
// the unsaved timeline / template
const TimelineTitleAndDescription = /*#__PURE__*/_react.default.memo(({
  closeSaveTimeline,
  initialFocus,
  timelineId,
  showWarning
}) => {
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    isSaving,
    description = '',
    status,
    title = '',
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['isSaving', 'description', 'status', 'title', 'timelineType'], getTimeline(state, timelineId)));
  const prevIsSaving = (0, _usePrevious.default)(isSaving);
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleCreateNewTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _api.TimelineType.default
  });
  const handleSubmit = (0, _react.useCallback)((titleAndDescription, isValid) => {
    if (isValid) {
      dispatch(_timeline2.timelineActions.updateTitleAndDescription({
        id: timelineId,
        ...titleAndDescription
      }));
    }
    return Promise.resolve();
  }, [dispatch, timelineId]);
  const initialState = (0, _react.useMemo)(() => ({
    title,
    description
  }), [title, description]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    id: 'timelineTitleAndDescriptionForm',
    schema: _schema.formSchema,
    onSubmit: handleSubmit,
    options: {
      stripEmptyFields: false
    },
    defaultValue: initialState
  });
  const {
    isSubmitted,
    isSubmitting,
    submit
  } = form;
  const onSubmit = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.TIMELINE_ACTIONS.SAVE
    });
    submit();
  }, [submit, startTransaction]);
  const handleCancel = (0, _react.useCallback)(() => {
    if (showWarning) {
      handleCreateNewTimeline();
    }
    closeSaveTimeline();
  }, [closeSaveTimeline, handleCreateNewTimeline, showWarning]);
  const closeModalText = (0, _react.useMemo)(() => {
    if (status === _api.TimelineStatus.draft && showWarning) {
      return timelineType === _api.TimelineType.template ? i18n.DISCARD_TIMELINE_TEMPLATE : i18n.DISCARD_TIMELINE;
    }
    return i18n.CLOSE_MODAL;
  }, [showWarning, status, timelineType]);
  const modalHeader = (0, _react.useMemo)(() => status === _api.TimelineStatus.draft ? timelineType === _api.TimelineType.template ? i18n.SAVE_TIMELINE_TEMPLATE : i18n.SAVE_TIMELINE : timelineType === _api.TimelineType.template ? i18n.NAME_TIMELINE_TEMPLATE : i18n.NAME_TIMELINE, [status, timelineType]);
  const saveButtonTitle = (0, _react.useMemo)(() => status === _api.TimelineStatus.draft && showWarning ? timelineType === _api.TimelineType.template ? i18n.SAVE_TIMELINE_TEMPLATE : i18n.SAVE_TIMELINE : i18n.SAVE, [showWarning, status, timelineType]);
  const calloutMessage = (0, _react.useMemo)(() => i18n.UNSAVED_TIMELINE_WARNING(timelineType), [timelineType]);
  const descriptionLabel = (0, _react.useMemo)(() => `${i18n.TIMELINE_DESCRIPTION} (${i18n.OPTIONAL})`, []);
  const titleFieldProps = (0, _react.useMemo)(() => ({
    'aria-label': i18n.TIMELINE_TITLE,
    autoFocus: initialFocus === 'title',
    'data-test-subj': 'save-timeline-title',
    disabled: isSaving,
    spellCheck: true,
    placeholder: timelineType === _api.TimelineType.template ? commonI18n.UNTITLED_TEMPLATE : commonI18n.UNTITLED_TIMELINE
  }), [initialFocus, isSaving, timelineType]);
  const descriptionFieldProps = (0, _react.useMemo)(() => ({
    'aria-label': i18n.TIMELINE_DESCRIPTION,
    autoFocus: initialFocus === 'description',
    'data-test-subj': 'save-timeline-description',
    disabled: isSaving,
    placeholder: commonI18n.DESCRIPTION
  }), [initialFocus, isSaving]);
  (0, _react.useEffect)(() => {
    if (isSubmitted && !isSaving && prevIsSaving) {
      closeSaveTimeline();
    }
  }, [isSubmitted, isSaving, prevIsSaving, closeSaveTimeline]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "save-timeline-modal",
    maxWidth: _notes_size.NOTES_PANEL_WIDTH,
    onClose: closeSaveTimeline
  }, isSaving && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "primary",
    position: "absolute",
    "data-test-subj": "progress-bar"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": "modal-header"
  }, modalHeader), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, showWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutMessage,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "save-timeline-callout"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "title",
    fullWidth: true,
    label: i18n.TITLE,
    euiFieldProps: titleFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    label: descriptionLabel,
    path: "description",
    fullWidth: true,
    euiFieldProps: descriptionFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: false,
    onClick: handleCancel,
    isDisabled: isSaving,
    "data-test-subj": "close-button"
  }, closeModalText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    isDisabled: isSaving || isSubmitting,
    fill: true,
    onClick: onSubmit,
    "data-test-subj": "save-button"
  }, saveButtonTitle)))))));
});
exports.TimelineTitleAndDescription = TimelineTitleAndDescription;
TimelineTitleAndDescription.displayName = 'TimelineTitleAndDescription';