"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompactFooter = exports.footerHeight = exports.ServerSideEventCount = exports.PagingControlComponent = exports.PagingControl = exports.FooterComponent = exports.Footer = exports.EventsCountComponent = exports.EventsCount = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _event_details_width_context = require("../../../../common/components/events_viewer/event_details_width_context");
var _timeline = require("../../../store/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isCompactFooter = width => width < 600;
exports.isCompactFooter = isCompactFooter;
const FixedWidthLastUpdatedContainer = /*#__PURE__*/_react.default.memo(({
  updatedAt
}) => {
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const width = (0, _event_details_width_context.useEventDetailsWidthContext)();
  const compact = (0, _react.useMemo)(() => isCompactFooter(width), [width]);
  return updatedAt > 0 ? /*#__PURE__*/_react.default.createElement(FixedWidthLastUpdated, {
    "data-test-subj": "fixed-width-last-updated",
    compact: compact
  }, timelines.getLastUpdated({
    updatedAt,
    compact
  })) : null;
});
FixedWidthLastUpdatedContainer.displayName = 'FixedWidthLastUpdatedContainer';
const FixedWidthLastUpdated = _styledComponents.default.div`
  width: ${({
  compact
}) => !compact ? 200 : 25}px;
  overflow: hidden;
  text-align: end;
`;
FixedWidthLastUpdated.displayName = 'FixedWidthLastUpdated';
const FooterContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup).attrs(({
  height
}) => ({
  style: {
    height: `${height}px`
  }
}))`
  flex: 0 0 auto;
`;
FooterContainer.displayName = 'FooterContainer';
const FooterFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 35px;
  width: 100%;
`;
FooterFlexGroup.displayName = 'FooterFlexGroup';
const LoadingPanelContainer = _styledComponents.default.div`
  padding-top: 3px;
`;
LoadingPanelContainer.displayName = 'LoadingPanelContainer';
const PopoverRowItems = (0, _styledComponents.default)(_eui.EuiPopover)`
  .euiButtonEmpty__content {
    padding: 0px 0px;
  }
`;
PopoverRowItems.displayName = 'PopoverRowItems';
const ServerSideEventCount = _styledComponents.default.div`
  margin: 0 5px 0 5px;
`;
exports.ServerSideEventCount = ServerSideEventCount;
ServerSideEventCount.displayName = 'ServerSideEventCount';

/** The height of the footer, exported for use in height calculations */
const footerHeight = 40; // px

/** Displays the server-side count of events */
exports.footerHeight = footerHeight;
const EventsCountComponent = ({
  closePopover,
  documentType,
  footerText,
  isOpen,
  items,
  itemsCount,
  onClick,
  serverSideEventCount
}) => {
  const totalCount = (0, _react.useMemo)(() => serverSideEventCount > 0 ? serverSideEventCount : 0, [serverSideEventCount]);
  return /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(PopoverRowItems, {
    className: "footer-popover",
    id: "customizablePagination",
    "data-test-subj": "timelineSizeRowPopover",
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "local-events-count",
      color: "hollow"
    }, itemsCount, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: _helpers.EVENTS_COUNT_BUTTON_CLASS_NAME,
      size: "s",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onClick,
      "data-test-subj": "local-events-count-button"
    })), ` ${i18n.OF} `),
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "timelinePickSizeRow"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, totalCount, " ", footerText)
  }, /*#__PURE__*/_react.default.createElement(ServerSideEventCount, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "server-side-event-count"
  }, totalCount), ' ', documentType)));
};
exports.EventsCountComponent = EventsCountComponent;
EventsCountComponent.displayName = 'EventsCountComponent';
const EventsCount = /*#__PURE__*/_react.default.memo(EventsCountComponent);
exports.EventsCount = EventsCount;
EventsCount.displayName = 'EventsCount';
const TimelinePaginationContainer = _styledComponents.default.div`
  ul.euiPagination__list {
    li.euiPagination__item:last-child {
      ${({
  hideLastPage
}) => `${hideLastPage ? 'display:none' : ''}`};
    }
  }
`;
const PagingControlComponent = ({
  activePage,
  isLoading,
  onPageClick,
  totalCount,
  totalPages
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${i18n.LOADING}...`);
  }
  if (!totalPages) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(TimelinePaginationContainer, {
    hideLastPage: totalCount > 9999
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "data-test-subj": "timeline-pagination",
    pageCount: totalPages,
    activePage: activePage,
    onPageClick: onPageClick
  }));
};
exports.PagingControlComponent = PagingControlComponent;
PagingControlComponent.displayName = 'PagingControlComponent';
const PagingControl = /*#__PURE__*/_react.default.memo(PagingControlComponent);
exports.PagingControl = PagingControl;
PagingControl.displayName = 'PagingControl';
/** Renders a loading indicator and paging controls */
const FooterComponent = ({
  activePage,
  updatedAt,
  height,
  id,
  isLive,
  isLoading,
  itemsCount,
  itemsPerPage,
  itemsPerPageOptions,
  onChangePage,
  totalCount
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [paginationLoading, setPaginationLoading] = (0, _react.useState)(false);
  const getManageTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    documentType = i18n.TOTAL_COUNT_OF_EVENTS,
    loadingText = i18n.LOADING_EVENTS,
    footerText = i18n.TOTAL_COUNT_OF_EVENTS
  } = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, id));
  const handleChangePageClick = (0, _react.useCallback)(nextPage => {
    setPaginationLoading(true);
    onChangePage(nextPage);
  }, [onChangePage]);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), [setIsPopoverOpen]);
  const onChangeItemsPerPage = (0, _react.useCallback)(itemsChangedPerPage => dispatch(_timeline.timelineActions.updateItemsPerPage({
    id,
    itemsPerPage: itemsChangedPerPage
  })), [dispatch, id]);
  const rowItems = (0, _react.useMemo)(() => itemsPerPageOptions && itemsPerPageOptions.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: item,
    icon: itemsPerPage === item ? 'check' : 'empty',
    "data-test-subj": `items-per-page-option-${item}`,
    onClick: () => {
      closePopover();
      onChangeItemsPerPage(item);
    }
  }, `${item} ${i18n.ROWS}`)), [closePopover, itemsPerPage, itemsPerPageOptions, onChangeItemsPerPage]);
  const totalPages = (0, _react.useMemo)(() => Math.ceil(totalCount / itemsPerPage), [itemsPerPage, totalCount]);
  (0, _react.useEffect)(() => {
    if (paginationLoading && !isLoading) {
      setPaginationLoading(false);
    }
  }, [isLoading, paginationLoading]);
  if (isLoading && !paginationLoading) {
    return /*#__PURE__*/_react.default.createElement(LoadingPanelContainer, null, timelines.getLoadingPanel({
      dataTestSubj: 'LoadingPanelTimeline',
      height: '35px',
      showBorder: false,
      text: loadingText,
      width: '100%'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(FooterContainer, {
    "data-test-subj": "timeline-footer",
    direction: "column",
    gutterSize: "none",
    height: height,
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(FooterFlexGroup, {
    alignItems: "center",
    "data-test-subj": "footer-flex-group",
    direction: "row",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "event-count-container",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "events-count",
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(EventsCount, {
    closePopover: closePopover,
    documentType: documentType,
    footerText: footerText,
    isOpen: isPopoverOpen,
    items: rowItems,
    itemsCount: itemsCount,
    onClick: onButtonClick,
    serverSideEventCount: totalCount
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "last-updated-container",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(FixedWidthLastUpdatedContainer, {
    updatedAt: updatedAt
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "paging-control-container",
    grow: false
  }, isLive ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "is-live-on-message"
  }, /*#__PURE__*/_react.default.createElement("b", null, i18n.AUTO_REFRESH_ACTIVE, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "text",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.footer.autoRefreshActiveTooltip",
      defaultMessage: "While auto-refresh is enabled, timeline will show you the latest {numberOfItems} events that match your query.",
      values: {
        numberOfItems: itemsCount
      }
    }),
    type: "iInCircle"
  }))) : /*#__PURE__*/_react.default.createElement(PagingControl, {
    "data-test-subj": "paging-control",
    totalCount: totalCount,
    totalPages: totalPages,
    activePage: activePage,
    onPageClick: handleChangePageClick,
    isLoading: isLoading
  }))));
};
exports.FooterComponent = FooterComponent;
FooterComponent.displayName = 'FooterComponent';
const Footer = /*#__PURE__*/_react.default.memo(FooterComponent);
exports.Footer = Footer;
Footer.displayName = 'Footer';