"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HIGHLIGHTED_DROP_TARGET_CLASS_NAME = exports.Empty = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _and_or_badge = require("../../../../common/components/and_or_badge");
var _add_data_provider_popover = require("./add_data_provider_popover");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HIGHLIGHTED_DROP_TARGET_CLASS_NAME = 'highlighted-drop-target';
exports.HIGHLIGHTED_DROP_TARGET_CLASS_NAME = HIGHLIGHTED_DROP_TARGET_CLASS_NAME;
const Text = (0, _styledComponents.default)(_eui.EuiText)`
  overflow: hidden;
  margin: 5px 0 5px 0;
  padding: 3px;
  white-space: nowrap;
`;
Text.displayName = 'Text';
const BadgeHighlighted = (0, _styledComponents.default)(_eui.EuiBadge)`
  height: 20px;
  margin: 0 5px 0 5px;
  maxwidth: 85px;
  minwidth: 85px;
`;
BadgeHighlighted.displayName = 'BadgeHighlighted';
const HighlightedBackground = _styledComponents.default.span`
  background-color: ${props => props.theme.eui.euiColorLightShade};
`;
HighlightedBackground.displayName = 'HighlightedBackground';
const EmptyContainer = _styledComponents.default.div`
  width: ${props => props.showSmallMsg ? '60px' : 'auto'};
  align-items: center;
  display: flex;
  flex-direction: column;
  flex-wrap: wrap;
  justify-content: center;
  user-select: none;
  align-content: center;
  ${props => props.showSmallMsg ? `
      border-right: 1px solid ${props.theme.eui.euiColorMediumShade};
      margin-right: 10px;
    ` : `
  min-height: 100px;
  + div {
    display: none !important;
   }
  `}
`;
EmptyContainer.displayName = 'EmptyContainer';
const NoWrap = _styledComponents.default.div`
  align-items: center;
  display: flex;
  flex-direction: row;
  flex-wrap: no-wrap;
`;
NoWrap.displayName = 'NoWrap';
/**
 * Prompts the user to drop anything with a facet count into the data providers section.
 */
const Empty = /*#__PURE__*/_react.default.memo(({
  showSmallMsg = false,
  browserFields,
  timelineId
}) => /*#__PURE__*/_react.default.createElement(EmptyContainer, {
  className: "timeline-drop-area-empty",
  "data-test-subj": "empty",
  showSmallMsg: showSmallMsg
}, !showSmallMsg && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(NoWrap, null, /*#__PURE__*/_react.default.createElement(Text, {
  color: "subdued",
  size: "s",
  className: "timeline-drop-area-empty__text"
}, i18n.DROP_ANYTHING), /*#__PURE__*/_react.default.createElement(HighlightedBackground, null, /*#__PURE__*/_react.default.createElement(BadgeHighlighted, {
  className: HIGHLIGHTED_DROP_TARGET_CLASS_NAME
}, i18n.HIGHLIGHTED)), /*#__PURE__*/_react.default.createElement(Text, {
  color: "subdued",
  size: "s",
  className: "timeline-drop-area-empty__text"
}, i18n.HERE_TO_BUILD_AN), /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
  type: "or"
}), /*#__PURE__*/_react.default.createElement(Text, {
  color: "subdued",
  size: "s",
  className: "timeline-drop-area-empty__text"
}, i18n.QUERY)), /*#__PURE__*/_react.default.createElement(_add_data_provider_popover.AddDataProviderPopover, {
  browserFields: browserFields,
  timelineId: timelineId
})), showSmallMsg && /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
  type: "or"
})));
exports.Empty = Empty;
Empty.displayName = 'Empty';