"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../../common/components/draggables");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapping = {
  open: 'primary',
  acknowledged: 'warning',
  closed: 'default'
};
const StyledEuiBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  text-transform: capitalize;
`;
const RuleStatusComponent = ({
  contextId,
  eventId,
  fieldName,
  fieldType,
  isAggregatable,
  isDraggable,
  value,
  onClick,
  onClickAriaLabel,
  iconSide,
  iconType
}) => {
  const color = (0, _react.useMemo)(() => (0, _fp.getOr)('default', `${value}`, mapping), [value]);
  const badge = /*#__PURE__*/_react.default.createElement(StyledEuiBadge, {
    color: color,
    onClick: onClick,
    onClickAriaLabel: onClickAriaLabel,
    iconType: iconType,
    iconSide: iconSide
  }, value);
  return isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    id: `alert-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    isDraggable: false,
    value: `${value}`,
    tooltipContent: fieldName
  }, badge) : badge;
};
const RuleStatus = /*#__PURE__*/_react.default.memo(RuleStatusComponent);
exports.RuleStatus = RuleStatus;
RuleStatus.displayName = 'RuleStatus';