"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reasonColumnRenderer = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("./constants");
var _get_row_renderer = require("./get_row_renderer");
var _plain_column_renderer = require("./plain_column_renderer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reasonColumnRenderer = {
  isInstance: (0, _fp.isEqual)(_constants.REASON_FIELD_NAME),
  renderColumn: ({
    columnName,
    ecsData,
    eventId,
    field,
    isDetails,
    isDraggable = true,
    linkValues,
    rowRenderers = [],
    scopeId,
    truncate,
    values
  }) => {
    if (isDetails && values && ecsData && rowRenderers) {
      return values.map((value, i) => /*#__PURE__*/_react.default.createElement(ReasonCell, {
        ecsData: ecsData,
        key: `reason-column-renderer-value-${scopeId}-${columnName}-${eventId}-${field.id}-${value}-${i}`,
        rowRenderers: rowRenderers,
        scopeId: scopeId,
        value: value
      }));
    } else {
      return _plain_column_renderer.plainColumnRenderer.renderColumn({
        columnName,
        eventId,
        field,
        isDetails,
        isDraggable,
        linkValues,
        scopeId,
        truncate,
        values
      });
    }
  }
};
exports.reasonColumnRenderer = reasonColumnRenderer;
const ReasonCell = ({
  ecsData,
  rowRenderers,
  scopeId,
  value
}) => {
  const rowRenderer = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data: ecsData,
    rowRenderers
  }), [ecsData, rowRenderers]);
  const rowRender = (0, _react.useMemo)(() => {
    return rowRenderer && rowRenderer.renderRow({
      data: ecsData,
      isDraggable: false,
      scopeId
    });
  }, [rowRenderer, ecsData, scopeId]);

  // We don't currently show enriched renders for rule preview table
  const isPlainText = (0, _react.useMemo)(() => scopeId === _securitysolutionDataTable.TableId.rulePreview, [scopeId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rowRenderer && rowRender && !isPlainText ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    className: "eui-xScroll",
    "data-test-subj": "reason-cell-renderer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-displayInlineBlock"
  }, rowRender))) : value);
};