"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessDraggableWithNonExistentProcess = exports.ProcessDraggable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgamePid,
  endgameProcessName,
  eventId,
  processExecutable,
  processName,
  processPid,
  isDraggable
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processName) && (0, _helpers.isNillEmptyOrNotFinite)(processExecutable) && (0, _helpers.isNillEmptyOrNotFinite)(endgameProcessName) && (0, _helpers.isNillEmptyOrNotFinite)(processPid) && (0, _helpers.isNillEmptyOrNotFinite)(endgamePid)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, !(0, _helpers.isNillEmptyOrNotFinite)(processName) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.name",
    value: processName,
    iconType: "console",
    isDraggable: isDraggable,
    fieldType: "keyword",
    isAggregatable: true
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(processExecutable) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.executable",
    value: processExecutable,
    iconType: "console",
    isDraggable: isDraggable,
    fieldType: "keyword",
    isAggregatable: true
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgameProcessName) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.process_name",
    value: endgameProcessName,
    iconType: "console",
    isDraggable: isDraggable,
    fieldType: "keyword",
    isAggregatable: true
  })) : null, !(0, _helpers.isNillEmptyOrNotFinite)(processPid) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.pid",
    queryValue: String(processPid),
    value: `(${String(processPid)})`,
    isDraggable: isDraggable,
    fieldType: "keyword",
    isAggregatable: true
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgamePid) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.pid",
    queryValue: String(endgamePid),
    value: `(${String(endgamePid)})`,
    isDraggable: isDraggable,
    fieldType: "keyword",
    isAggregatable: true
  })) : null);
});
exports.ProcessDraggable = ProcessDraggable;
ProcessDraggable.displayName = 'ProcessDraggable';
const ProcessDraggableWithNonExistentProcess = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgamePid,
  endgameProcessName,
  eventId,
  processExecutable,
  processName,
  processPid,
  isDraggable
}) => {
  if (endgamePid == null && endgameProcessName == null && processExecutable == null && processName == null && processPid == null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.NON_EXISTENT);
  } else {
    return /*#__PURE__*/_react.default.createElement(ProcessDraggable, {
      contextId: contextId,
      endgamePid: endgamePid,
      endgameProcessName: endgameProcessName,
      eventId: eventId,
      processExecutable: processExecutable,
      processName: processName,
      processPid: processPid,
      isDraggable: isDraggable
    });
  }
});
exports.ProcessDraggableWithNonExistentProcess = ProcessDraggableWithNonExistentProcess;
ProcessDraggableWithNonExistentProcess.displayName = 'ProcessDraggableWithNonExistentProcess';