"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedFieldValue = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _endpoint_agent_status = require("../../../../../common/components/endpoint/endpoint_agent_status");
var _constants = require("../../../../../../common/cti/constants");
var _draggables = require("../../../../../common/components/draggables");
var _bytes = require("./bytes");
var _duration = require("../../../duration");
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _formatted_ip = require("../../../formatted_ip");
var _port = require("../../../../../explore/network/components/port");
var _helpers = require("../../../../../explore/network/components/port/helpers");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _constants2 = require("./constants");
var _formatted_field_helpers = require("./formatted_field_helpers");
var _rule_status = require("./rule_status");
var _host_name = require("./host_name");
var _user_name = require("./user_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

// simple black-list to prevent dragging and dropping fields such as message name
const columnNamesNotDraggable = [_constants2.MESSAGE_FIELD_NAME];
const FormattedFieldValueComponent = ({
  asPlainText,
  Component,
  contextId,
  eventId,
  fieldFormat,
  isAggregatable = false,
  fieldName,
  fieldType = '',
  isButton,
  isObjectArray = false,
  isDraggable = true,
  onClick,
  onClickAriaLabel,
  title,
  truncate = true,
  value,
  linkValue
}) => {
  if (isObjectArray || asPlainText) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `formatted-field-${fieldName}`
    }, value);
  } else if (fieldType === _constants2.IP_FIELD_TYPE) {
    return /*#__PURE__*/_react.default.createElement(_formatted_ip.FormattedIp, {
      Component: Component,
      eventId: eventId,
      contextId: contextId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isButton: isButton,
      isDraggable: isDraggable,
      value: !(0, _fp.isNumber)(value) ? value : String(value),
      onClick: onClick,
      title: title,
      truncate: truncate
    });
  } else if (fieldType === _constants2.GEO_FIELD_TYPE) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
  } else if (fieldType === _constants2.DATE_FIELD_TYPE) {
    const classNames = truncate ? 'eui-textTruncate eui-alignMiddle' : undefined;
    return isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      field: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
      isDraggable: isDraggable,
      tooltipContent: null,
      value: `${value}`
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      className: classNames,
      fieldName: fieldName,
      value: value
    })) : /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      className: classNames,
      fieldName: fieldName,
      value: value
    });
  } else if (_helpers.PORT_NAMES.some(portName => fieldName === portName)) {
    return /*#__PURE__*/_react.default.createElement(_port.Port, {
      Component: Component,
      contextId: contextId,
      eventId: eventId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      title: title,
      value: `${value}`
    });
  } else if (fieldName === _duration.EVENT_DURATION_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_duration.Duration, {
      contextId: contextId,
      eventId: eventId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      value: `${value}`
    });
  } else if (fieldName === _constants2.HOST_NAME_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_host_name.HostName, {
      Component: Component,
      contextId: contextId,
      eventId: eventId,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      fieldName: fieldName,
      isDraggable: isDraggable,
      isButton: isButton,
      onClick: onClick,
      title: title,
      value: value
    });
  } else if (fieldName === _constants2.USER_NAME_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
      Component: Component,
      contextId: contextId,
      eventId: eventId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      isButton: isButton,
      onClick: onClick,
      title: title,
      value: value
    });
  } else if (fieldFormat === _bytes.BYTES_FORMAT) {
    return /*#__PURE__*/_react.default.createElement(_bytes.Bytes, {
      contextId: contextId,
      eventId: eventId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      value: `${value}`
    });
  } else if (fieldName === _constants2.SIGNAL_RULE_NAME_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
      Component: Component,
      contextId: contextId,
      eventId: eventId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      isButton: isButton,
      onClick: onClick,
      linkValue: linkValue,
      title: title,
      truncate: truncate,
      value: value
    });
  } else if (fieldName === _constants2.EVENT_MODULE_FIELD_NAME) {
    return (0, _formatted_field_helpers.renderEventModule)({
      contextId,
      eventId,
      fieldName,
      fieldType,
      isAggregatable,
      isDraggable,
      linkValue,
      truncate,
      value
    });
  } else if (fieldName === _constants2.SIGNAL_STATUS_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_rule_status.RuleStatus, {
      contextId: contextId,
      eventId: eventId,
      fieldName: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      value: value,
      onClick: onClick,
      onClickAriaLabel: onClickAriaLabel,
      iconType: isButton ? 'arrowDown' : undefined,
      iconSide: isButton ? 'right' : undefined
    });
  } else if (fieldName === _constants2.AGENT_STATUS_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatusById, {
      endpointAgentId: String(value !== null && value !== void 0 ? value : ''),
      "data-test-subj": "endpointHostAgentStatus"
    });
  } else if ([_constants2.RULE_REFERENCE_FIELD_NAME, _constants2.REFERENCE_URL_FIELD_NAME, _constants2.EVENT_URL_FIELD_NAME, _constants.INDICATOR_REFERENCE].includes(fieldName)) {
    return (0, _formatted_field_helpers.renderUrl)({
      contextId,
      Component,
      eventId,
      fieldName,
      fieldType,
      isAggregatable,
      isDraggable,
      truncate,
      title,
      value
    });
  } else if (columnNamesNotDraggable.includes(fieldName) || !isDraggable) {
    return truncate && !(0, _fp.isEmpty)(value) ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
      "data-test-subj": "truncatable-message"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "message-tool-tip",
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, value)))
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `formatted-field-${fieldName}`
    }, value))) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `formatted-field-${fieldName}`
    }, value);
  } else {
    const contentValue = (0, _empty_value.getOrEmptyTagFromValue)(value);
    const content = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, contentValue) : contentValue;
    return /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      field: fieldName,
      id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
      fieldType: fieldType !== null && fieldType !== void 0 ? fieldType : '',
      isAggregatable: isAggregatable,
      isDraggable: isDraggable,
      value: `${value}`,
      tooltipContent: fieldType === _constants2.DATE_FIELD_TYPE || fieldType === _duration.EVENT_DURATION_FIELD_NAME ? null : fieldName
    }, content);
  }
};
const FormattedFieldValue = /*#__PURE__*/_react.default.memo(FormattedFieldValueComponent);
exports.FormattedFieldValue = FormattedFieldValue;