"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertRenderer = exports.DEFAULT_CONTEXT_ID = exports.ALERT_RENDERER_FIELDS = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _alert_field = require("./alert_field");
var _api = require("../../../../../../../common/types/timeline/api");
var _helpers = require("./helpers");
var _helpers2 = require("../helpers");
var _row_renderer = require("../row_renderer");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONTEXT_ID = 'alert-renderer';
exports.DEFAULT_CONTEXT_ID = DEFAULT_CONTEXT_ID;
const ALERT_RENDERER_FIELDS = [_helpers.DESTINATION_IP, _helpers.DESTINATION_PORT, _helpers.EVENT_CATEGORY, _helpers.FILE_NAME, _helpers.HOST_NAME, _helpers.KIBANA_ALERT_RULE_NAME, _helpers.KIBANA_ALERT_SEVERITY, _helpers.PROCESS_NAME, _helpers.PROCESS_PARENT_NAME, _helpers.SOURCE_IP, _helpers.SOURCE_PORT, _helpers.USER_NAME];
exports.ALERT_RENDERER_FIELDS = ALERT_RENDERER_FIELDS;
const AlertRendererFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  gap: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const alertRenderer = {
  id: _api.RowRendererId.alert,
  isInstance: ecs => (0, _helpers.eventKindMatches)((0, _fp.get)('event.kind', ecs)),
  renderRow: ({
    contextId = DEFAULT_CONTEXT_ID,
    data,
    isDraggable,
    scopeId
  }) => {
    const eventId = (0, _fp.get)(_helpers.ID, data);
    const destinationIp = (0, _fp.get)(_helpers.DESTINATION_IP, data);
    const destinationPort = (0, _fp.get)(_helpers.DESTINATION_PORT, data);
    const eventCategory = (0, _fp.get)(_helpers.EVENT_CATEGORY, data);
    const fileName = (0, _fp.get)(_helpers.FILE_NAME, data);
    const hostName = (0, _fp.get)(_helpers.HOST_NAME, data);
    const kibanaAlertRuleName = (0, _fp.get)(_helpers.KIBANA_ALERT_RULE_NAME, data);
    const kibanaAlertSeverity = (0, _fp.get)(_helpers.KIBANA_ALERT_SEVERITY, data);
    const processName = (0, _fp.get)(_helpers.PROCESS_NAME, data);
    const processParentName = (0, _fp.get)(_helpers.PROCESS_PARENT_NAME, data);
    const sourceIp = (0, _fp.get)(_helpers.SOURCE_IP, data);
    const sourcePort = (0, _fp.get)(_helpers.SOURCE_PORT, data);
    const userName = (0, _fp.get)(_helpers.USER_NAME, data);
    return /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, null, /*#__PURE__*/_react.default.createElement(_helpers2.Details, {
      "data-test-subj": "alertRenderer"
    }, /*#__PURE__*/_react.default.createElement(AlertRendererFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      justifyContent: "center",
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.EVENT_CATEGORY,
      eventId: eventId,
      field: _helpers.EVENT_CATEGORY,
      isDraggable: isDraggable,
      scopeId: scopeId,
      values: eventCategory
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "event"
    }, ` ${i18n.EVENT} `)), (0, _helpers.showWith)({
      data,
      fieldNames: _helpers.WITH_FIELD_NAMES
    }) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "with"
    }, ` ${i18n.WITH} `)), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.PROCESS_NAME,
      eventId: eventId,
      field: _helpers.PROCESS_NAME,
      isDraggable: isDraggable,
      prefix: ` ${i18n.PROCESS} `,
      suffix: ", ",
      scopeId: scopeId,
      values: processName
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.PROCESS_PARENT_NAME,
      eventId: eventId,
      field: _helpers.PROCESS_PARENT_NAME,
      isDraggable: isDraggable,
      prefix: ` ${i18n.PARENT_PROCESS} `,
      suffix: ", ",
      scopeId: scopeId,
      values: processParentName
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.FILE_NAME,
      eventId: eventId,
      field: _helpers.FILE_NAME,
      isDraggable: isDraggable,
      prefix: ` ${i18n.FILE} `,
      suffix: ", ",
      scopeId: scopeId,
      values: fileName
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.SOURCE_IP,
      eventId: eventId,
      field: _helpers.SOURCE_IP,
      isDraggable: isDraggable,
      prefix: ` ${i18n.SOURCE} `,
      scopeId: scopeId,
      values: sourceIp
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.SOURCE_PORT,
      eventId: eventId,
      field: _helpers.SOURCE_PORT,
      isDraggable: isDraggable,
      prefix: ":",
      suffix: ", ",
      scopeId: scopeId,
      values: sourcePort
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.DESTINATION_IP,
      eventId: eventId,
      field: _helpers.DESTINATION_IP,
      isDraggable: isDraggable,
      prefix: ` ${i18n.DESTINATION} `,
      scopeId: scopeId,
      values: destinationIp
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.DESTINATION_PORT,
      eventId: eventId,
      field: _helpers.DESTINATION_PORT,
      isDraggable: isDraggable,
      prefix: ":",
      suffix: ", ",
      scopeId: scopeId,
      values: destinationPort
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.USER_NAME,
      eventId: eventId,
      field: _helpers.USER_NAME,
      isDraggable: isDraggable,
      prefix: ` ${i18n.BY} `,
      scopeId: scopeId,
      values: userName
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.HOST_NAME,
      eventId: eventId,
      field: _helpers.HOST_NAME,
      isDraggable: isDraggable,
      prefix: ` ${i18n.ON} `,
      scopeId: scopeId,
      values: hostName
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.KIBANA_ALERT_SEVERITY,
      eventId: eventId,
      field: _helpers.KIBANA_ALERT_SEVERITY,
      isDraggable: isDraggable,
      prefix: ` ${i18n.CREATED} `,
      suffix: ` ${i18n.ALERT} `,
      scopeId: scopeId,
      values: kibanaAlertSeverity
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.KIBANA_ALERT_RULE_NAME,
      eventId: eventId,
      field: _helpers.KIBANA_ALERT_RULE_NAME,
      isDraggable: isDraggable,
      suffix: ".",
      scopeId: scopeId,
      values: kibanaAlertRuleName
    }))));
  }
};
exports.alertRenderer = alertRenderer;