"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedUser = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _basic_table = require("../../../../common/components/ml/tables/basic_table");
var _columns = require("./columns");
var _hooks = require("./hooks");
var _formatted_date = require("../../../../common/components/formatted_date");
var _constants = require("./constants");
var _inspect = require("../../../../common/components/inspect");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagedUser = ({
  managedUser,
  contextID,
  isDraggable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const managedItems = (0, _hooks.useManagedUserItems)(managedUser.details);
  const [isManagedDataToggleOpen, setManagedDataToggleOpen] = (0, _react.useState)(false);
  const onToggleManagedData = (0, _react.useCallback)(() => {
    setManagedDataToggleOpen(isOpen => !isOpen);
  }, [setManagedDataToggleOpen]);
  const managedUserTableColumns = (0, _react.useMemo)(() => (0, _columns.getManagedUserTableColumns)(contextID, isDraggable), [isDraggable, contextID]);
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const installedIntegrationHref = (0, _react.useMemo)(() => getAppUrl({
    appId: 'integrations',
    path: _constants.INSTALL_INTEGRATION_HREF
  }), [getAppUrl]);
  if (!managedUser.isLoading && !managedUser.isIntegrationEnabled) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.MANAGED_DATA_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      "data-test-subj": "managedUser-integration-disable-callout"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.NO_ACTIVE_INTEGRATION_TITLE),
      body: /*#__PURE__*/_react.default.createElement("p", null, i18n.NO_ACTIVE_INTEGRATION_TEXT),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        href: installedIntegrationHref
      }, i18n.ADD_EXTERNAL_INTEGRATION_BUTTON)
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.MANAGED_DATA_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    isLoading: managedUser.isLoading,
    id: 'managedUser-data',
    "data-test-subj": "managedUser-data",
    forceState: isManagedDataToggleOpen ? 'open' : 'closed',
    buttonProps: {
      'data-test-subj': 'managedUser-accordion-button',
      css: (0, _react2.css)`
              color: ${euiTheme.colors.primary};
            `
    },
    buttonContent: isManagedDataToggleOpen ? i18n.HIDE_AZURE_DATA_BUTTON : i18n.SHOW_AZURE_DATA_BUTTON,
    onToggle: onToggleManagedData,
    extraAction: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      css: (0, _react2.css)`
                  margin-right: ${euiTheme.size.s};
                `
    }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
      queryId: _constants.MANAGED_USER_QUERY_ID,
      title: i18n.MANAGED_USER_INSPECT_TITLE
    })), managedUser.lastSeen.date && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.timeline.userDetails.updatedTime",
      defaultMessage: "Updated {time}",
      values: {
        time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: managedUser.lastSeen.date,
          dateFormat: "MMM D, YYYY",
          relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS
        })
      }
    })),
    css: (0, _react2.css)`
            .euiAccordion__optionalAction {
              margin-left: auto;
            }
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, managedItems || managedUser.isLoading ? /*#__PURE__*/_react.default.createElement(_basic_table.BasicTable, {
    loading: managedUser.isLoading,
    "data-test-subj": "managedUser-table",
    columns: managedUserTableColumns,
    items: managedItems !== null && managedItems !== void 0 ? managedItems : []
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "managedUser-no-data",
    title: i18n.NO_AZURE_DATA_TITLE,
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.NO_AZURE_DATA_TEXT)))))));
};
exports.ManagedUser = ManagedUser;