"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedUserItems = exports.useObservedUser = exports.useManagedUserItems = exports.useManagedUser = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_strategy = require("../../../../../common/search_strategy");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
var _observed_details = require("../../../../explore/users/containers/users/observed_details");
var _use_first_last_seen = require("../../../../common/containers/use_first_last_seen");
var _use_installed_integrations = require("../../../../detections/components/rules/related_integrations/use_installed_integrations");
var _constants = require("./constants");
var _manage_query = require("../../../../common/components/page/manage_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedUserItems = userData => (0, _react.useMemo)(() => {
  var _userData$details$use, _userData$details$use2, _userData$details$hos, _userData$details$hos2, _userData$details$hos3, _userData$details$hos4, _userData$details$hos5;
  return !userData.details ? [] : [{
    label: i18n.USER_ID,
    values: (_userData$details$use = userData.details.user) === null || _userData$details$use === void 0 ? void 0 : _userData$details$use.id,
    field: 'user.id'
  }, {
    label: 'Domain',
    values: (_userData$details$use2 = userData.details.user) === null || _userData$details$use2 === void 0 ? void 0 : _userData$details$use2.domain,
    field: 'user.domain'
  }, {
    label: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    field: 'anomalies',
    values: userData.anomalies
  }, {
    label: i18n.FIRST_SEEN,
    values: userData.firstSeen.date ? [userData.firstSeen.date] : undefined,
    field: '@timestamp'
  }, {
    label: i18n.LAST_SEEN,
    values: userData.lastSeen.date ? [userData.lastSeen.date] : undefined,
    field: '@timestamp'
  }, {
    label: i18n.OPERATING_SYSTEM_TITLE,
    values: (_userData$details$hos = userData.details.host) === null || _userData$details$hos === void 0 ? void 0 : (_userData$details$hos2 = _userData$details$hos.os) === null || _userData$details$hos2 === void 0 ? void 0 : _userData$details$hos2.name,
    field: 'host.os.name'
  }, {
    label: i18n.FAMILY,
    values: (_userData$details$hos3 = userData.details.host) === null || _userData$details$hos3 === void 0 ? void 0 : (_userData$details$hos4 = _userData$details$hos3.os) === null || _userData$details$hos4 === void 0 ? void 0 : _userData$details$hos4.family,
    field: 'host.os.family'
  }, {
    label: i18n.IP_ADDRESSES,
    values: (_userData$details$hos5 = userData.details.host) === null || _userData$details$hos5 === void 0 ? void 0 : _userData$details$hos5.ip,
    field: 'host.ip'
  }];
}, [userData.details, userData.anomalies, userData.firstSeen, userData.lastSeen]);
exports.useObservedUserItems = useObservedUserItems;
const useManagedUserItems = managedUserDetails => (0, _react.useMemo)(() => {
  var _managedUserDetails$u;
  return !managedUserDetails ? null : [{
    label: i18n.USER_ID,
    value: managedUserDetails.user.id,
    field: 'user.id'
  }, {
    label: i18n.FULL_NAME,
    value: managedUserDetails.user.full_name,
    field: 'user.full_name'
  }, {
    label: i18n.FIRST_NAME,
    value: managedUserDetails.user.first_name
  }, {
    label: i18n.LAST_NAME,
    value: managedUserDetails.user.last_name
  }, {
    label: i18n.PHONE,
    value: (_managedUserDetails$u = managedUserDetails.user.phone) === null || _managedUserDetails$u === void 0 ? void 0 : _managedUserDetails$u.join(', ')
  }];
}, [managedUserDetails]);
exports.useManagedUserItems = useManagedUserItems;
const useManagedUser = userName => {
  const {
    to,
    from,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    loading: loadingManagedUser,
    result: {
      userDetails: managedUserDetails
    },
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.UsersQueries.managedDetails,
    initialResult: {},
    errorMessage: i18n.FAIL_MANAGED_USER
  });
  (0, _react.useEffect)(() => {
    if (!isInitializing) {
      search({
        defaultIndex: _constants.MANAGED_USER_INDEX,
        factoryQueryType: _search_strategy.UsersQueries.managedDetails,
        userName
      });
    }
  }, [from, search, to, userName, isInitializing]);
  const {
    data: installedIntegrations,
    isLoading: loadingIntegrations
  } = (0, _use_installed_integrations.useInstalledIntegrations)({
    packages: [_constants.MANAGED_USER_PACKAGE_NAME]
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: _constants.MANAGED_USER_QUERY_ID,
    loading: loadingManagedUser
  });
  const isIntegrationEnabled = (0, _react.useMemo)(() => !!(installedIntegrations !== null && installedIntegrations !== void 0 && installedIntegrations.some(({
    package_name: packageName,
    is_enabled: isEnabled
  }) => packageName === _constants.MANAGED_USER_PACKAGE_NAME && isEnabled)), [installedIntegrations]);
  const [loadingFirstSeen, {
    firstSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'user.name',
    value: userName,
    defaultIndex: _constants.MANAGED_USER_INDEX,
    order: _search_strategy.Direction.asc
  });
  const [loadingLastSeen, {
    lastSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'user.name',
    value: userName,
    defaultIndex: _constants.MANAGED_USER_INDEX,
    order: _search_strategy.Direction.desc
  });
  return (0, _react.useMemo)(() => ({
    details: managedUserDetails,
    isLoading: loadingManagedUser || loadingIntegrations,
    isIntegrationEnabled,
    firstSeen: {
      date: firstSeen,
      isLoading: loadingFirstSeen
    },
    lastSeen: {
      date: lastSeen,
      isLoading: loadingLastSeen
    }
  }), [firstSeen, isIntegrationEnabled, loadingIntegrations, lastSeen, loadingFirstSeen, loadingLastSeen, loadingManagedUser, managedUserDetails]);
};
exports.useManagedUser = useManagedUser;
const useObservedUser = userName => {
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    to,
    from,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [loadingObservedUser, {
    userDetails: observedUserDetails,
    inspect,
    refetch,
    id: queryId
  }] = (0, _observed_details.useObservedUserDetails)({
    endDate: to,
    startDate: from,
    userName,
    indexNames: selectedPatterns,
    skip: isInitializing
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId,
    loading: loadingObservedUser
  });
  const [loadingFirstSeen, {
    firstSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'user.name',
    value: userName,
    defaultIndex: selectedPatterns,
    order: _search_strategy.Direction.asc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  const [loadingLastSeen, {
    lastSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'user.name',
    value: userName,
    defaultIndex: selectedPatterns,
    order: _search_strategy.Direction.desc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  return (0, _react.useMemo)(() => ({
    details: observedUserDetails,
    isLoading: loadingObservedUser,
    firstSeen: {
      date: firstSeen,
      isLoading: loadingFirstSeen
    },
    lastSeen: {
      date: lastSeen,
      isLoading: loadingLastSeen
    }
  }), [firstSeen, lastSeen, loadingFirstSeen, loadingLastSeen, loadingObservedUser, observedUserDetails]);
};
exports.useObservedUser = useObservedUser;