"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("../../../../helpers");
var _timeline = require("../../../store/timeline");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _active_timeline_context = require("../../../containers/active_timeline_context");
var _timeline2 = require("../../../../../common/types/timeline");
var _defaults = require("../../../store/timeline/defaults");
var _use_selector = require("../../../../common/hooks/use_selector");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDetailPanel = ({
  entityType,
  isFlyoutView,
  sourcererScope,
  scopeId,
  tabType = _timeline2.TimelineTabs.query
}) => {
  const {
    browserFields,
    selectedPatterns,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const dispatch = (0, _reactRedux.useDispatch)();
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _timeline.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const eventDetailsIndex = (0, _react.useMemo)(() => selectedPatterns.join(','), [selectedPatterns]);
  const expandedDetail = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref, _ref2;
    return (_ref = (_ref2 = getScope && getScope(state, scopeId)) !== null && _ref2 !== void 0 ? _ref2 : _defaults.timelineDefaults) === null || _ref === void 0 ? void 0 : _ref.expandedDetail;
  });
  const onPanelClose = (0, _react.useRef)(() => {});
  const noopPanelClose = () => {};
  const shouldShowDetailsPanel = (0, _react.useMemo)(() => {
    var _expandedDetail$tabTy;
    if (tabType && expandedDetail && expandedDetail[tabType] && !!((_expandedDetail$tabTy = expandedDetail[tabType]) !== null && _expandedDetail$tabTy !== void 0 && _expandedDetail$tabTy.panelView)) {
      return true;
    }
    return false;
  }, [expandedDetail, tabType]);
  const scopedActions = (0, _helpers.getScopedActions)(scopeId);

  // We could just surface load details panel, but rather than have users be concerned
  // of the config for a panel, they can just pass the base necessary values to a panel specific function
  const loadDetailsPanel = (0, _react.useCallback)(panelConfig => {
    if (panelConfig && scopedActions) {
      dispatch(scopedActions.toggleDetailPanel({
        ...panelConfig,
        tabType,
        id: scopeId
      }));
    }
  }, [scopedActions, scopeId, dispatch, tabType]);
  const openEventDetailsPanel = (0, _react.useCallback)((eventId, onClose) => {
    if (eventId) {
      loadDetailsPanel({
        panelView: 'eventDetail',
        params: {
          eventId,
          indexName: eventDetailsIndex
        }
      });
    }
    onPanelClose.current = onClose !== null && onClose !== void 0 ? onClose : noopPanelClose;
  }, [loadDetailsPanel, eventDetailsIndex]);
  const openHostDetailsPanel = (0, _react.useCallback)((hostName, onClose) => {
    loadDetailsPanel({
      panelView: 'hostDetail',
      params: {
        hostName
      }
    });
    onPanelClose.current = onClose !== null && onClose !== void 0 ? onClose : noopPanelClose;
  }, [loadDetailsPanel]);
  const openNetworkDetailsPanel = (0, _react.useCallback)((ip, flowTarget, onClose) => {
    loadDetailsPanel({
      panelView: 'networkDetail',
      params: {
        ip,
        flowTarget
      }
    });
    onPanelClose.current = onClose !== null && onClose !== void 0 ? onClose : noopPanelClose;
  }, [loadDetailsPanel]);
  const openUserDetailsPanel = (0, _react.useCallback)((userName, onClose) => {
    loadDetailsPanel({
      panelView: 'userDetail',
      params: {
        userName
      }
    });
    onPanelClose.current = onClose !== null && onClose !== void 0 ? onClose : noopPanelClose;
  }, [loadDetailsPanel]);
  const handleOnDetailsPanelClosed = (0, _react.useCallback)(() => {
    var _expandedDetail$tabTy2;
    if (onPanelClose.current) onPanelClose.current();
    if (scopedActions) {
      dispatch(scopedActions.toggleDetailPanel({
        tabType,
        id: scopeId
      }));
    }
    if (tabType && (_expandedDetail$tabTy2 = expandedDetail[tabType]) !== null && _expandedDetail$tabTy2 !== void 0 && _expandedDetail$tabTy2.panelView && scopeId === _timeline2.TimelineId.active && shouldShowDetailsPanel) {
      _active_timeline_context.activeTimeline.toggleExpandedDetail({});
    }
  }, [scopedActions, tabType, expandedDetail, scopeId, shouldShowDetailsPanel, dispatch]);
  const DetailsPanel = (0, _react.useMemo)(() => shouldShowDetailsPanel ? /*#__PURE__*/_react.default.createElement(_.DetailsPanel, {
    browserFields: browserFields,
    entityType: entityType,
    handleOnPanelClosed: handleOnDetailsPanelClosed,
    isFlyoutView: isFlyoutView,
    runtimeMappings: runtimeMappings,
    tabType: tabType,
    scopeId: scopeId
  }) : null, [browserFields, entityType, handleOnDetailsPanelClosed, isFlyoutView, runtimeMappings, shouldShowDetailsPanel, tabType, scopeId]);
  return {
    openEventDetailsPanel,
    openHostDetailsPanel,
    openNetworkDetailsPanel,
    openUserDetailsPanel,
    handleOnDetailsPanelClosed,
    shouldShowDetailsPanel,
    DetailsPanel
  };
};
exports.useDetailPanel = useDetailPanel;