"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _api = require("../../../../../common/types/timeline/api");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchRowContainer = _styledComponents.default.div`
  &:not(:last-child) {
    margin-bottom: ${props => props.theme.eui.euiSizeL};
  }
`;
SearchRowContainer.displayName = 'SearchRowContainer';
const SearchRowFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${props => props.theme.eui.euiSizeXS};
`;
SearchRowFlexGroup.displayName = 'SearchRowFlexGroup';
/**
 * Renders the row containing the search input and Only Favorites filter
 */
const SearchRow = /*#__PURE__*/_react.default.memo(({
  favoriteCount,
  onlyFavorites,
  onQueryChange,
  onToggleOnlyFavorites,
  children,
  timelineType
}) => {
  const searchBox = (0, _react.useMemo)(() => ({
    placeholder: timelineType === _api.TimelineType.default ? i18n.SEARCH_PLACEHOLDER : i18n.SEARCH_TEMPLATE_PLACEHOLDER,
    incremental: false,
    'data-test-subj': 'search-bar'
  }), [timelineType]);
  return /*#__PURE__*/_react.default.createElement(SearchRowContainer, null, /*#__PURE__*/_react.default.createElement(SearchRowFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: searchBox,
    onChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "only-favorites-toggle",
    hasActiveFilters: onlyFavorites,
    onClick: onToggleOnlyFavorites,
    numFilters: favoriteCount !== null && favoriteCount !== void 0 ? favoriteCount : undefined
  }, i18n.ONLY_FAVORITES), !!children && children)))));
});
exports.SearchRow = SearchRow;
SearchRow.displayName = 'SearchRow';