"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditTimelineBatchActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _api = require("../../../../common/types/timeline/api");
var i18n = _interopRequireWildcard(require("./translations"));
var _export_timeline = require("./export_timeline");
var _edit_timeline_actions = require("./edit_timeline_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExportedIds = selectedTimelines => {
  const array = Array.isArray(selectedTimelines) ? selectedTimelines : [selectedTimelines];
  return array.reduce((acc, item) => item.savedObjectId != null ? [...acc, item.savedObjectId] : [...acc], []);
};
const useEditTimelineBatchActions = ({
  deleteTimelines,
  selectedItems,
  tableRef,
  timelineType = _api.TimelineType.default
}) => {
  const {
    enableExportTimelineDownloader,
    disableExportTimelineDownloader,
    isEnableDownloader,
    isDeleteTimelineModalOpen,
    onOpenDeleteTimelineModal,
    onCloseDeleteTimelineModal
  } = (0, _edit_timeline_actions.useEditTimelineActions)();
  const onCompleteBatchActions = (0, _react.useCallback)(closePopover => {
    if (closePopover != null) closePopover();
    if (tableRef != null && tableRef.current != null) {
      tableRef.current.changeSelection([]);
    }
    disableExportTimelineDownloader();
    onCloseDeleteTimelineModal();
  }, [disableExportTimelineDownloader, onCloseDeleteTimelineModal, tableRef]);
  const selectedIds = (0, _react.useMemo)(() => getExportedIds(selectedItems !== null && selectedItems !== void 0 ? selectedItems : []), [selectedItems]);
  const handleEnableExportTimelineDownloader = (0, _react.useCallback)(() => enableExportTimelineDownloader(), [enableExportTimelineDownloader]);
  const handleOnOpenDeleteTimelineModal = (0, _react.useCallback)(() => onOpenDeleteTimelineModal(), [onOpenDeleteTimelineModal]);
  const getBatchItemsPopoverContent = (0, _react.useCallback)(closePopover => {
    var _selectedItems$length, _selectedItems$length2, _selectedItems$0$titl, _selectedItems$;
    const disabled = selectedItems == null || selectedItems.length === 0;
    const items = [];
    if (selectedItems) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "export-timeline-action",
        disabled: disabled,
        icon: "exportAction",
        key: "ExportItemKey",
        onClick: handleEnableExportTimelineDownloader
      }, i18n.EXPORT_SELECTED));
    }
    if (deleteTimelines) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "delete-timeline-action",
        disabled: disabled,
        icon: "trash",
        key: "DeleteItemKey",
        onClick: handleOnOpenDeleteTimelineModal
      }, i18n.DELETE_SELECTED));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_export_timeline.EditTimelineActions, {
      deleteTimelines: deleteTimelines,
      ids: selectedIds,
      isEnableDownloader: isEnableDownloader,
      isDeleteTimelineModalOpen: isDeleteTimelineModalOpen,
      onComplete: onCompleteBatchActions.bind(null, closePopover),
      title: (selectedItems === null || selectedItems === void 0 ? void 0 : selectedItems.length) !== 1 ? timelineType === _api.TimelineType.template ? i18n.SELECTED_TEMPLATES((_selectedItems$length = selectedItems === null || selectedItems === void 0 ? void 0 : selectedItems.length) !== null && _selectedItems$length !== void 0 ? _selectedItems$length : 0) : i18n.SELECTED_TIMELINES((_selectedItems$length2 = selectedItems === null || selectedItems === void 0 ? void 0 : selectedItems.length) !== null && _selectedItems$length2 !== void 0 ? _selectedItems$length2 : 0) : (_selectedItems$0$titl = (_selectedItems$ = selectedItems[0]) === null || _selectedItems$ === void 0 ? void 0 : _selectedItems$.title) !== null && _selectedItems$0$titl !== void 0 ? _selectedItems$0$titl : ''
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items
    }));
  }, [selectedItems, deleteTimelines, selectedIds, isEnableDownloader, isDeleteTimelineModalOpen, onCompleteBatchActions, timelineType, handleEnableExportTimelineDownloader, handleOnOpenDeleteTimelineModal]);
  return {
    onCompleteBatchActions,
    getBatchItemsPopoverContent
  };
};
exports.useEditTimelineBatchActions = useEditTimelineBatchActions;