"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CancelButton = exports.AddNote = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _app = require("../../../../common/store/app");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _new_note = require("./new_note");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddNotesContainer = _styledComponents.default.div`
  margin-bottom: 5px;
  user-select: none;
`;
AddNotesContainer.displayName = 'AddNotesContainer';
const ButtonsContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-top: 5px;
`;
ButtonsContainer.displayName = 'ButtonsContainer';
const CancelButton = /*#__PURE__*/_react.default.memo(({
  onCancelAddNote
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "cancel",
  onClick: onCancelAddNote
}, i18n.CANCEL));
exports.CancelButton = CancelButton;
CancelButton.displayName = 'CancelButton';

/** Displays an input for entering a new note, with an adjacent "Add" button */
const AddNote = /*#__PURE__*/_react.default.memo(({
  associateNote,
  newNote,
  onCancelAddNote,
  updateNewNote,
  autoFocusDisabled = false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const authenticatedUser = (0, _kibana.useCurrentUser)();
  const [isMarkdownInvalid, setIsMarkdownInvalid] = (0, _react.useState)(false);
  const updateNote = (0, _react.useCallback)(note => dispatch(_app.appActions.updateNote({
    note
  })), [dispatch]);
  const handleClick = (0, _react.useCallback)(() => {
    const user = authenticatedUser === null || authenticatedUser === void 0 ? void 0 : authenticatedUser.username;
    if (user) {
      (0, _helpers.updateAndAssociateNode)({
        associateNote,
        newNote,
        updateNewNote,
        updateNote,
        user
      });
    }
  }, [associateNote, newNote, updateNewNote, updateNote, authenticatedUser]);
  const onKeyDown = (0, _react.useCallback)(e => {
    // when editing notes, the row-level keyboard handlers shall not
    // receive keyboard events
    e.stopPropagation();
    if (e.key === 'Escape' && onCancelAddNote != null) {
      onCancelAddNote();
    }
  }, [onCancelAddNote]);
  const isAddNoteDisabled = (0, _react.useMemo)(() => {
    return newNote.trim().length === 0 || isMarkdownInvalid;
  }, [newNote, isMarkdownInvalid]);
  return /*#__PURE__*/_react.default.createElement(AddNotesContainer, {
    onKeyDown: onKeyDown,
    role: "dialog"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.YOU_ARE_EDITING_A_NOTE)), /*#__PURE__*/_react.default.createElement(_new_note.NewNote, {
    note: newNote,
    noteInputHeight: 200,
    updateNewNote: updateNewNote,
    autoFocusDisabled: autoFocusDisabled,
    setIsMarkdownInvalid: setIsMarkdownInvalid
  }), /*#__PURE__*/_react.default.createElement(ButtonsContainer, {
    gutterSize: "none"
  }, onCancelAddNote != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CancelButton, {
    onCancelAddNote: onCancelAddNote
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "add-note",
    isDisabled: isAddNoteDisabled,
    fill: true,
    onClick: handleClick
  }, i18n.ADD_NOTE)))));
});
exports.AddNote = AddNote;
AddNote.displayName = 'AddNote';