"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_selector = require("../../../common/hooks/use_selector");
var _bottom_bar = require("./bottom_bar");
var _pane = require("./pane");
var _selectors = require("./selectors");
var _use_timeline_save_prompt = require("../../../common/hooks/timeline/use_timeline_save_prompt");
var _timeline = require("../../store/timeline");
var _helpers = require("../timeline/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutComponent = ({
  timelineId,
  onAppLeave
}) => {
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    show
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, timelineId));
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleClose = (0, _react.useCallback)(() => {
    dispatch(_timeline.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
    (0, _helpers.focusActiveTimelineButton)();
  }, [dispatch, timelineId]);

  // ESC key closes Pane
  const onKeyDown = (0, _react.useCallback)(ev => {
    if (ev.key === _eui.keys.ESCAPE) {
      handleClose();
    }
  }, [handleClose]);
  (0, _use_timeline_save_prompt.useTimelineSavePrompt)(timelineId, onAppLeave);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !show
  }, /*#__PURE__*/_react.default.createElement(_pane.Pane, {
    timelineId: timelineId,
    visible: show
  })), /*#__PURE__*/_react.default.createElement(_bottom_bar.FlyoutBottomBar, {
    showTimelineHeaderPanel: !show,
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }));
};
FlyoutComponent.displayName = 'FlyoutComponent';
const Flyout = /*#__PURE__*/_react.default.memo(FlyoutComponent);
exports.Flyout = Flyout;
Flyout.displayName = 'Flyout';