"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineStatusByIdSelector = void 0;
var _reselect = require("reselect");
var _api = require("../../../../../common/types/timeline/api");
var _timeline = require("../../../store/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineStatusByIdSelector = () => (0, _reselect.createSelector)(_timeline.timelineSelectors.selectTimeline, timeline => {
  var _timeline$status, _timeline$updated;
  return {
    status: (_timeline$status = timeline === null || timeline === void 0 ? void 0 : timeline.status) !== null && _timeline$status !== void 0 ? _timeline$status : _api.TimelineStatus.draft,
    updated: (_timeline$updated = timeline === null || timeline === void 0 ? void 0 : timeline.updated) !== null && _timeline$updated !== void 0 ? _timeline$updated : undefined
  };
});
exports.getTimelineStatusByIdSelector = getTimelineStatusByIdSelector;