"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeList = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _side_effect_context = require("../side_effect_context");
var _styles = require("../styles");
var _styles2 = require("./styles");
var nodeModel = _interopRequireWildcard(require("../../../../common/endpoint/models/node"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _breadcrumbs = require("./breadcrumbs");
var _cube_for_process = require("./cube_for_process");
var _limit_warnings = require("../limit_warnings");
var _use_link_props = require("../use_link_props");
var _use_colors = require("../use_colors");
var _use_formatted_date = require("./use_formatted_date");
var _copyable_panel_field = require("./copyable_panel_field");
var _actions = require("../../store/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @elastic/eui/href-or-on-click */

/* eslint-disable react/display-name */

/**
 * The "default" view for the panel: A list of all the processes currently in the graph.
 */
const NodeList = /*#__PURE__*/(0, _react.memo)(({
  id
}) => {
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.processNameTitle', {
      defaultMessage: 'Process Name'
    }),
    sortable: true,
    truncateText: true,
    render(name, item) {
      return /*#__PURE__*/_react.default.createElement(NodeDetailLink, {
        id: id,
        name: name,
        nodeID: item.nodeID
      });
    }
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.timestampTitle', {
      defaultMessage: 'Timestamp'
    }),
    dataType: 'date',
    sortable: true,
    render(eventDate) {
      return /*#__PURE__*/_react.default.createElement(NodeDetailTimestamp, {
        eventDate: eventDate
      });
    }
  }], [id]);
  const processTableView = (0, _reactRedux.useSelector)((0, _react.useCallback)(state => {
    const {
      processNodePositions
    } = selectors.layout(state.analyzer.analyzerById[id]);
    const view = [];
    for (const treeNode of processNodePositions.keys()) {
      const name = nodeModel.nodeName(treeNode);
      const nodeID = nodeModel.nodeID(treeNode);
      if (nodeID !== undefined) {
        view.push({
          name,
          timestamp: nodeModel.timestampAsDate(treeNode),
          nodeID
        });
      }
    }
    return view;
  }, [id]));
  const numberOfProcesses = processTableView.length;
  const breadcrumbs = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.i18n.translate('xpack.securitySolution.resolver.panel.nodeList.title', {
        defaultMessage: 'All Process Events'
      })
    }];
  }, []);
  const children = (0, _reactRedux.useSelector)(state => selectors.hasMoreChildren(state.analyzer.analyzerById[id]));
  const ancestors = (0, _reactRedux.useSelector)(state => selectors.hasMoreAncestors(state.analyzer.analyzerById[id]));
  const generations = (0, _reactRedux.useSelector)(state => selectors.hasMoreGenerations(state.analyzer.analyzerById[id]));
  const showWarning = children === true || ancestors === true || generations === true;
  const rowProps = (0, _react.useMemo)(() => ({
    'data-test-subj': 'resolver:node-list:item'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_styles.StyledPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: breadcrumbs
  }), showWarning && /*#__PURE__*/_react.default.createElement(_limit_warnings.LimitWarning, {
    numberDisplayed: numberOfProcesses
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    rowProps: rowProps,
    "data-test-subj": "resolver:node-list",
    items: processTableView,
    columns: columns,
    sorting: true
  }));
});
exports.NodeList = NodeList;
function NodeDetailLink({
  id,
  name,
  nodeID
}) {
  const isOrigin = (0, _reactRedux.useSelector)(state => {
    return selectors.originID(state.analyzer.analyzerById[id]) === nodeID;
  });
  const nodeState = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer.analyzerById[id])(nodeID));
  const {
    descriptionText
  } = (0, _use_colors.useColors)();
  const linkProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeDetail',
    panelParameters: {
      nodeID
    }
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timestamp
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const handleOnClick = (0, _react.useCallback)(mouseEvent => {
    linkProps.onClick(mouseEvent);
    dispatch((0, _actions.userSelectedResolverNode)({
      id,
      nodeID,
      time: timestamp()
    }));
  }, [timestamp, linkProps, dispatch, nodeID, id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleOnClick,
    href: linkProps.href,
    "data-test-subj": "resolver:node-list:node-link",
    "data-test-node-id": nodeID
  }, name === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.valueMissingDescription', {
    defaultMessage: 'Value is missing'
  })) : /*#__PURE__*/_react.default.createElement(_styles2.StyledButtonTextContainer, null, /*#__PURE__*/_react.default.createElement(_cube_for_process.CubeForProcess, {
    id: id,
    state: nodeState,
    isOrigin: isOrigin,
    "data-test-subj": "resolver:node-list:node-link:icon"
  }), /*#__PURE__*/_react.default.createElement(_styles2.StyledLabelContainer, null, isOrigin && /*#__PURE__*/_react.default.createElement(_styles2.StyledAnalyzedEvent, {
    color: descriptionText,
    "data-test-subj": "resolver:node-list:node-link:analyzed-event"
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.panel.table.row.analyzedEvent', {
    defaultMessage: 'ANALYZED EVENT'
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledLabelTitle, {
    "data-test-subj": "resolver:node-list:node-link:title"
  }, name))));
}
const NodeDetailTimestamp = /*#__PURE__*/(0, _react.memo)(({
  eventDate
}) => {
  const formattedDate = (0, _use_formatted_date.useFormattedDate)(eventDate);
  return formattedDate ? /*#__PURE__*/_react.default.createElement(_copyable_panel_field.CopyablePanelField, {
    textToCopy: formattedDate,
    content: formattedDate
  }) : /*#__PURE__*/_react.default.createElement("span", null, '—');
});