"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetail = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _styles = require("./styles");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var eventModel = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var _generated_text = require("../generated_text");
var _copyable_panel_field = require("./copyable_panel_field");
var _breadcrumbs = require("./breadcrumbs");
var _process_event = require("../../models/process_event");
var nodeDataModel = _interopRequireWildcard(require("../../models/node_data"));
var _cube_for_process = require("./cube_for_process");
var _use_cube_assets = require("../use_cube_assets");
var _panel_loading = require("./panel_loading");
var _styles2 = require("../styles");
var _use_link_props = require("../use_link_props");
var _use_formatted_date = require("./use_formatted_date");
var _panel_content_error = require("./panel_content_error");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

const StyledCubeForProcess = (0, _styledComponents.default)(_cube_for_process.CubeForProcess)`
  position: relative;
`;
const nodeDetailError = _i18n.i18n.translate('xpack.securitySolution.resolver.panel.nodeDetail.Error', {
  defaultMessage: 'Node details were unable to be retrieved'
});
const NodeDetail = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeID
}) {
  const processEvent = (0, _reactRedux.useSelector)(state => nodeDataModel.firstEvent(selectors.nodeDataForID(state.analyzer.analyzerById[id])(nodeID)));
  const nodeStatus = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer.analyzerById[id])(nodeID));
  return nodeStatus === 'loading' ? /*#__PURE__*/_react.default.createElement(_styles2.StyledPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, {
    id: id
  })) : processEvent ? /*#__PURE__*/_react.default.createElement(_styles2.StyledPanel, {
    hasBorder: true,
    "data-test-subj": "resolver:panel:node-detail"
  }, /*#__PURE__*/_react.default.createElement(NodeDetailView, {
    id: id,
    nodeID: nodeID,
    processEvent: processEvent
  })) : /*#__PURE__*/_react.default.createElement(_styles2.StyledPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_panel_content_error.PanelContentError, {
    id: id,
    translatedErrorMessage: nodeDetailError
  }));
});

/**
 * A description list view of all the Metadata that goes with a particular process event, like:
 * Created, PID, User/Domain, etc.
 */
exports.NodeDetail = NodeDetail;
const NodeDetailView = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  processEvent,
  nodeID
}) {
  const processName = eventModel.processNameSafeVersion(processEvent);
  const nodeState = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer.analyzerById[id])(nodeID));
  const relatedEventTotal = (0, _reactRedux.useSelector)(state => {
    return selectors.relatedEventTotalCount(state.analyzer.analyzerById[id])(nodeID);
  });
  const eventTime = eventModel.eventTimestamp(processEvent);
  const dateTime = (0, _use_formatted_date.useFormattedDate)(eventTime);
  const processInfoEntry = (0, _react.useMemo)(() => {
    const createdEntry = {
      title: '@timestamp',
      description: dateTime
    };
    const pathEntry = {
      title: 'process.executable',
      description: (0, _process_event.processPath)(processEvent)
    };
    const pidEntry = {
      title: 'process.pid',
      description: (0, _process_event.processPID)(processEvent)
    };
    const userEntry = {
      title: 'user.name',
      description: eventModel.userName(processEvent)
    };
    const processEntityId = {
      title: 'process.entity_id',
      description: eventModel.entityId(processEvent)
    };
    const domainEntry = {
      title: 'user.domain',
      description: eventModel.userDomain(processEvent)
    };
    const parentPidEntry = {
      title: 'process.parent.pid',
      description: eventModel.parentPID(processEvent)
    };
    const md5Entry = {
      title: 'process.hash.md5',
      description: eventModel.md5HashForProcess(processEvent)
    };
    const commandLineEntry = {
      title: 'process.args',
      description: eventModel.argsForProcess(processEvent)
    };
    const flattenedEntries = [];
    const flattenedDescriptionListData = [createdEntry, pathEntry, pidEntry, processEntityId, userEntry, domainEntry, parentPidEntry, md5Entry, commandLineEntry].reduce((flattenedList, entry) => {
      if (Array.isArray(entry.description)) {
        return [...flattenedList, ...entry.description.map(value => {
          return {
            title: entry.title,
            description: value
          };
        })];
      } else {
        return [...flattenedList, entry];
      }
    }, flattenedEntries);

    // This is the data in {title, description} form for the EuiDescriptionList to display
    const processDescriptionListData = flattenedDescriptionListData.filter(entry => {
      return entry.description !== undefined;
    }).map(entry => {
      return {
        ...entry,
        description: /*#__PURE__*/_react.default.createElement(_copyable_panel_field.CopyablePanelField, {
          textToCopy: String(entry.description),
          content: /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, null, String(entry.description))
        })
      };
    });
    return processDescriptionListData;
  }, [dateTime, processEvent]);
  const nodesLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodes'
  });
  const crumbs = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.processDescList.events', {
        defaultMessage: 'Events'
      }),
      'data-test-subj': 'resolver:node-detail:breadcrumbs:node-list-link',
      ...nodesLinkNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.detailsForProcessName",
        values: {
          processName
        },
        defaultMessage: "Details for: {processName}"
      })
    }];
  }, [processName, nodesLinkNavProps]);
  const {
    descriptionText
  } = (0, _use_cube_assets.useCubeAssets)(id, nodeState, false);
  const nodeDetailNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEvents',
    panelParameters: {
      nodeID
    }
  });
  const titleID = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)('resolverTable')(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: crumbs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledTitle, {
    "aria-describedby": titleID
  }, /*#__PURE__*/_react.default.createElement(StyledCubeForProcess, {
    id: id,
    "data-test-subj": "resolver:node-detail:title-icon",
    state: nodeState
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "resolver:node-detail:title"
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, null, processName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", {
    id: titleID
  }, descriptionText))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, nodeDetailNavProps, {
    "data-test-subj": "resolver:node-detail:node-events-link"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.processDescList.numberOfEvents",
    values: {
      relatedEventTotal
    },
    defaultMessage: "{relatedEventTotal} Events"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_styles.StyledDescriptionList, {
    "data-test-subj": "resolver:node-detail",
    type: "column",
    align: "left",
    titleProps: {
      'data-test-subj': 'resolver:node-detail:entry-title',
      className: 'desc-title'
      // Casting this to allow data attribute
    },

    descriptionProps: {
      'data-test-subj': 'resolver:node-detail:entry-description'
    },
    compressed: true,
    listItems: processInfoEntry
  }));
});