"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedEventsFetcher = RelatedEventsFetcher;
var _lodash = require("lodash");
var selectors = _interopRequireWildcard(require("../selectors"));
var _action = require("../data/action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RelatedEventsFetcher(dataAccessLayer, api) {
  const last = {};
  // Call this after each state change.
  // This fetches the ResolverTree for the current entityID
  // if the entityID changes while
  return async id => {
    const state = api.getState();
    if (!last[id]) {
      last[id] = undefined;
    }
    const newParams = selectors.panelViewAndParameters(state.analyzer.analyzerById[id]);
    const isLoadingMoreEvents = selectors.isLoadingMoreNodeEventsInCategory(state.analyzer.analyzerById[id]);
    const indices = selectors.eventIndices(state.analyzer.analyzerById[id]);
    const oldParams = last[id];
    const detectedBounds = selectors.detectedBounds(state.analyzer.analyzerById[id]);
    const timeRangeFilters = detectedBounds !== undefined ? undefined : selectors.timeRangeFilters(state.analyzer.analyzerById[id]);
    // Update this each time before fetching data (or even if we don't fetch data) so that subsequent actions that call this (concurrently) will have up to date info.
    last[id] = newParams;
    async function fetchEvents({
      nodeID,
      eventCategory,
      cursor
    }) {
      let result = null;
      try {
        if (cursor) {
          result = await dataAccessLayer.eventsWithEntityIDAndCategory({
            entityID: nodeID,
            category: eventCategory,
            after: cursor,
            indexPatterns: indices,
            timeRange: timeRangeFilters
          });
        } else {
          result = await dataAccessLayer.eventsWithEntityIDAndCategory({
            entityID: nodeID,
            category: eventCategory,
            indexPatterns: indices,
            timeRange: timeRangeFilters
          });
        }
      } catch (error) {
        api.dispatch((0, _action.serverFailedToReturnNodeEventsInCategory)({
          id,
          nodeID,
          eventCategory,
          cursor
        }));
      }
      if (result) {
        api.dispatch((0, _action.serverReturnedNodeEventsInCategory)({
          id,
          events: result.events,
          eventCategory,
          cursor: result.nextEvent,
          nodeID
        }));
      }
    }

    // If the panel view params have changed and the current panel view is either `nodeEventsInCategory` or `eventDetail`, then fetch the related events for that nodeID.
    if (!(0, _lodash.isEqual)(newParams, oldParams)) {
      if (newParams.panelView === 'nodeEventsInCategory') {
        const nodeID = newParams.panelParameters.nodeID;
        await fetchEvents({
          nodeID,
          eventCategory: newParams.panelParameters.eventCategory,
          cursor: null
        });
      }
    } else if (isLoadingMoreEvents) {
      const nodeEventsInCategory = state.analyzer.analyzerById[id].data.nodeEventsInCategory;
      if (nodeEventsInCategory !== undefined) {
        await fetchEvents(nodeEventsInCategory);
      }
    }
  };
}