"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulRecentTimelines = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _api = require("../../../../common/types/timeline/api");
var _all = require("../../../timelines/containers/all");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _actions = require("../../../timelines/store/timeline/actions");
var _recent_timelines = require("./recent_timelines");
var i18n = _interopRequireWildcard(require("./translations"));
var _loading_placeholders = require("../loading_placeholders");
var _use_timeline_status = require("../../../timelines/components/open_timeline/use_timeline_status");
var _kibana = require("../../../common/lib/kibana");
var _types = require("../../../app/types");
var _constants = require("../../../../common/constants");
var _link_to = require("../../../common/components/link_to");
var _links = require("../../../common/components/links");
var _search_strategy = require("../../../../common/search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE = 3;
const StatefulRecentTimelinesComponent = ({
  filterBy
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const updateIsLoading = (0, _react.useCallback)(payload => dispatch((0, _actions.updateIsLoading)(payload)), [dispatch]);
  const updateTimeline = (0, _react.useMemo)(() => (0, _helpers.dispatchUpdateTimeline)(dispatch), [dispatch]);
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.timelines);
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const onOpenTimeline = (0, _react.useCallback)(({
    duplicate,
    timelineId
  }) => {
    (0, _helpers.queryTimelineById)({
      duplicate,
      timelineId,
      updateIsLoading,
      updateTimeline
    });
  }, [updateIsLoading, updateTimeline]);
  const goToTimelines = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.timelines
    });
  }, [navigateToApp]);
  const noTimelinesMessage = filterBy === 'favorites' ? i18n.NO_FAVORITE_TIMELINES : i18n.NO_TIMELINES;
  const linkAllTimelines = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: goToTimelines,
    href: formatUrl('')
  }, i18n.VIEW_ALL_TIMELINES), [goToTimelines, formatUrl]);
  const loadingPlaceholders = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_loading_placeholders.LoadingPlaceholders, {
    lines: 2,
    placeholders: filterBy === 'favorites' ? 1 : PAGE_SIZE
  }), [filterBy]);
  const {
    fetchAllTimeline,
    timelines,
    loading
  } = (0, _all.useGetAllTimeline)();
  const timelineType = _api.TimelineType.default;
  const {
    timelineStatus
  } = (0, _use_timeline_status.useTimelineStatus)({
    timelineType
  });
  (0, _react.useEffect)(() => {
    fetchAllTimeline({
      pageInfo: {
        pageIndex: 1,
        pageSize: PAGE_SIZE
      },
      search: '',
      sort: {
        sortField: _api.SortFieldTimeline.updated,
        sortOrder: _search_strategy.Direction.desc
      },
      onlyUserFavorite: filterBy === 'favorites',
      status: timelineStatus,
      timelineType
    });
  }, [fetchAllTimeline, filterBy, timelineStatus, timelineType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading ? loadingPlaceholders : /*#__PURE__*/_react.default.createElement(_recent_timelines.RecentTimelines, {
    noTimelinesMessage: noTimelinesMessage,
    onOpenTimeline: onOpenTimeline,
    timelines: timelines !== null && timelines !== void 0 ? timelines : []
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, linkAllTimelines));
};
StatefulRecentTimelinesComponent.displayName = 'StatefulRecentTimelinesComponent';
const StatefulRecentTimelines = /*#__PURE__*/_react.default.memo(StatefulRecentTimelinesComponent);
exports.StatefulRecentTimelines = StatefulRecentTimelines;