"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelLinkPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _cti_enabled_module = require("./cti_enabled_module");
var _cti_disabled_module = require("./cti_disabled_module");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThreatIntelLinkPanelComponent = props => {
  const {
    allTiDataSources
  } = props;
  const isThreatIntelModuleEnabled = allTiDataSources.length > 0;
  return isThreatIntelModuleEnabled ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "cti-enabled-module"
  }, /*#__PURE__*/_react.default.createElement(_cti_enabled_module.CtiEnabledModule, (0, _extends2.default)({}, props, {
    allTiDataSources: allTiDataSources
  }))) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "cti-disabled-module"
  }, /*#__PURE__*/_react.default.createElement(_cti_disabled_module.CtiDisabledModule, null));
};
const ThreatIntelLinkPanel = /*#__PURE__*/_react.default.memo(ThreatIntelLinkPanelComponent);
exports.ThreatIntelLinkPanel = ThreatIntelLinkPanel;
ThreatIntelLinkPanel.displayName = 'ThreatIntelDashboardLinksComponent';