"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointNotice = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _routing = require("../../../management/common/routing");
var _use_navigate_to_app_event_handler = require("../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointNotice = /*#__PURE__*/(0, _react.memo)(({
  onDismiss
}) => {
  const {
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  const endpointsPath = (0, _routing.getEndpointListPath)({
    name: 'endpointList'
  });
  const endpointsLink = getUrlForApp(_constants.APP_UI_ID, {
    path: endpointsPath
  });
  const handleGetStartedClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(_constants.APP_UI_ID, {
    path: endpointsPath
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "endpoint-prompt-banner",
    iconType: "cheer",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endpointNotice.introducing",
      defaultMessage: "Introducing: "
    })), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endpointNotice.title",
      defaultMessage: "Endpoint Security"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.endpointNotice.message",
    defaultMessage: "Protect your hosts with threat prevention, detection, and deep security data visibility."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleGetStartedClick,
    href: endpointsLink
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.endpointNotice.tryButton",
    defaultMessage: "Try Endpoint Security"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDismiss
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.endpointNotice.dismiss",
    defaultMessage: "Dismiss message"
  }))));
});
exports.EndpointNotice = EndpointNotice;
EndpointNotice.displayName = 'EndpointNotice';