"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesMttr = void 0;
var _react = require("react");
var _uuid = require("uuid");
var _stat_reducer = require("./stat_reducer");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../../../../common/constants");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesMttr = ({
  deleteQuery,
  from,
  fromCompare,
  setQuery,
  skip = false,
  to,
  toCompare
}) => {
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const uniqueQueryId = (0, _react.useMemo)(() => `useCasesMttr-${(0, _uuid.v4)()}`, []);
  const [state, dispatch] = (0, _react.useReducer)(_stat_reducer.statReducer, {
    description: i18n.CASES_MTTR_DESCRIPTION,
    isLoading: true,
    percentage: {
      percent: null,
      color: 'hollow',
      note: i18n.NO_DATA('case')
    },
    stat: '-',
    testRef: 'casesMttr',
    title: i18n.CASES_MTTR_STAT,
    updatedAt: Date.now()
  });
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const fetchCases = async () => {
      try {
        const [responseCurrent, responseCompare] = await Promise.all([cases.api.cases.getCasesMetrics({
          from,
          to,
          owner: _constants.APP_ID,
          features: ['mttr']
        }, abortCtrl.signal), cases.api.cases.getCasesMetrics({
          from: fromCompare,
          to: toCompare,
          owner: _constants.APP_ID,
          features: ['mttr']
        }, abortCtrl.signal)]);
        const percentageChange = (0, _helpers.getPercChange)(responseCurrent.mttr, responseCompare.mttr);
        if (isSubscribed && responseCurrent.mttr != null) {
          dispatch({
            type: 'setStat',
            stat: (0, _helpers.makePrettyNumber)(responseCurrent.mttr)
          });
        } else if (isSubscribed) {
          dispatch({
            type: 'setStat',
            stat: '-'
          });
        }
        if (responseCurrent.mttr != null && responseCompare.mttr != null && percentageChange != null) {
          const isNegative = percentageChange.charAt(0) === '-';
          const isZero = percentageChange === '0.0%';
          dispatch({
            type: 'setPercentage',
            percentage: {
              percent: isNegative || isZero ? percentageChange : `+${percentageChange}`,
              color: isZero ? 'hollow' : isNegative ? 'success' // a negative change is good
              : 'danger',
              note: isZero ? i18n.NO_CHANGE('case resolution time') : i18n.STAT_DIFFERENCE({
                upOrDown: isNegative ? 'down' : 'up',
                percentageChange: isNegative ? percentageChange.substring(1) : percentageChange,
                stat: (0, _helpers.makePrettyNumber)(responseCompare.mttr),
                statType: 'case resolution time'
              })
            }
          });
        } else {
          const badCurrent = responseCurrent.mttr == null;
          const badCompare = responseCompare.mttr == null;
          const note = badCurrent && badCompare ? i18n.NO_DATA('case') : badCurrent ? i18n.NO_DATA_CURRENT('case') : i18n.NO_DATA_COMPARE('case');
          dispatch({
            type: 'setPercentage',
            percentage: {
              percent: null,
              color: 'hollow',
              note
            }
          });
        }
      } catch (error) {
        if (isSubscribed) {
          dispatch({
            type: 'setStat',
            stat: '-'
          });
        }
      }
      if (isSubscribed) {
        dispatch({
          type: 'setIsLoading',
          isLoading: false
        });
        dispatch({
          type: 'setUpdatedAt',
          updatedAt: Date.now()
        });
      }
    };
    if (!skip) {
      fetchCases();
      setQuery({
        id: uniqueQueryId,
        inspect: null,
        loading: false,
        refetch: fetchCases
      });
    }
    if (skip) {
      dispatch({
        type: 'setIsLoading',
        isLoading: false
      });
      isSubscribed = false;
      abortCtrl.abort();
    }
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
      if (deleteQuery) {
        deleteQuery({
          id: uniqueQueryId
        });
      }
    };
  }, [cases.api.cases, from, skip, to, setQuery, deleteQuery, uniqueQueryId, fromCompare, toCompare]);
  return state;
};
exports.useCasesMttr = useCasesMttr;