"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsByStatus = exports.severityLabels = exports.parseAlertsData = exports.getAlertsByStatusQuery = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_query = require("../../../../detections/containers/detection_engine/alerts/use_query");
var _constants = require("../../../../detections/containers/detection_engine/alerts/constants");
var _manage_query = require("../../../../common/components/page/manage_query");
var _translations = require("../translations");
var _inputs = require("../../../../common/store/inputs");
var _constants2 = require("../../../../common/store/inputs/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severityLabels = {
  critical: _translations.STATUS_CRITICAL_LABEL,
  high: _translations.STATUS_HIGH_LABEL,
  medium: _translations.STATUS_MEDIUM_LABEL,
  low: _translations.STATUS_LOW_LABEL
};
exports.severityLabels = severityLabels;
const getAlertsByStatusQuery = ({
  additionalFilters = [],
  from,
  to,
  entityFilter
}) => ({
  size: 0,
  query: {
    bool: {
      filter: [...additionalFilters, {
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      }, ...(entityFilter ? [{
        term: {
          [entityFilter.field]: entityFilter.value
        }
      }] : [])]
    }
  },
  aggs: {
    alertsByStatus: {
      terms: {
        field: 'kibana.alert.workflow_status'
      },
      aggs: {
        statusBySeverity: {
          terms: {
            field: 'kibana.alert.severity'
          }
        }
      }
    }
  }
});
exports.getAlertsByStatusQuery = getAlertsByStatusQuery;
const parseAlertsData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const statusBuckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.alertsByStatus) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  if (statusBuckets.length === 0) {
    return null;
  }
  return statusBuckets.reduce((parsedAlertsData, statusBucket) => {
    var _statusBucket$statusB, _statusBucket$statusB2;
    const severityBuckets = (_statusBucket$statusB = (_statusBucket$statusB2 = statusBucket.statusBySeverity) === null || _statusBucket$statusB2 === void 0 ? void 0 : _statusBucket$statusB2.buckets) !== null && _statusBucket$statusB !== void 0 ? _statusBucket$statusB : [];
    return {
      ...parsedAlertsData,
      [statusBucket.key]: {
        total: statusBucket.doc_count,
        severities: severityBuckets.map(severityBucket => ({
          key: severityBucket.key,
          value: severityBucket.doc_count,
          label: severityLabels[severityBucket.key]
        }))
      }
    };
  }, {});
};
exports.parseAlertsData = parseAlertsData;
const useAlertsByStatus = ({
  additionalFilters,
  entityFilter,
  queryId,
  signalIndexName,
  skip = false,
  to,
  from
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const [items, setItems] = (0, _react.useState)(null);
  const setQuery = (0, _react.useCallback)(({
    id,
    inspect,
    loading,
    refetch,
    searchSessionId
  }) => dispatch(_inputs.inputsActions.setQuery({
    inputId: _constants2.InputsModelId.global,
    id,
    inspect,
    loading,
    refetch,
    searchSessionId
  })), [dispatch]);
  const deleteQuery = (0, _react.useCallback)(({
    id
  }) => dispatch(_inputs.inputsActions.deleteOneQuery({
    inputId: _constants2.InputsModelId.global,
    id
  })), [dispatch]);
  const {
    data,
    loading: isLoading,
    refetch: refetchQuery,
    request,
    response,
    setQuery: setAlertsQuery
  } = (0, _use_query.useQueryAlerts)({
    query: getAlertsByStatusQuery({
      from,
      to,
      entityFilter,
      additionalFilters
    }),
    indexName: signalIndexName,
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.BY_STATUS
  });
  (0, _react.useEffect)(() => {
    setAlertsQuery(getAlertsByStatusQuery({
      from,
      to,
      entityFilter,
      additionalFilters
    }));
  }, [setAlertsQuery, from, to, entityFilter, additionalFilters]);
  (0, _react.useEffect)(() => {
    if (data == null) {
      setItems(null);
    } else {
      setItems(parseAlertsData(data));
    }
    setUpdatedAt(Date.now());
  }, [data]);
  const refetch = (0, _react.useCallback)(() => {
    if (!skip && refetchQuery) {
      refetchQuery();
    }
  }, [skip, refetchQuery]);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: {
      dsl: [request],
      response: [response]
    },
    refetch,
    setQuery,
    queryId,
    loading: isLoading
  });
  return {
    items,
    isLoading,
    updatedAt
  };
};
exports.useAlertsByStatus = useAlertsByStatus;