"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEndpointSecurityPackage = useGetEndpointSecurityPackage;
exports.useGetEndpointSpecificPolicies = useGetEndpointSpecificPolicies;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../common/constants");
var _ingest = require("./ingest");
var _policies = require("./policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetEndpointSpecificPolicies({
  onError,
  page,
  perPage
} = {
  page: 1,
  perPage: _constants.MANAGEMENT_DEFAULT_PAGE_SIZE
}) {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['endpointSpecificPolicies', page, perPage], () => {
    return (0, _policies.sendGetEndpointSpecificPackagePolicies)(http, {
      query: {
        page,
        perPage,
        withAgentCount: true
      }
    });
  }, onError ? {
    onError
  } : undefined);
}

/**
 * This hook returns the endpoint security package which contains endpoint version info
 */
function useGetEndpointSecurityPackage({
  customQueryOptions
}) {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['endpointPackageVersion', customQueryOptions], () => {
    return (0, _ingest.sendGetEndpointSecurityPackage)(http);
  }, customQueryOptions);
}