"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newTrustedAppToCreateExceptionListItem = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _constants = require("../../../../../common/endpoint/service/artifacts/constants");
var _exception_list_items = require("../../../../common/utils/exception_list_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPERATING_SYSTEM_TO_OS_TYPE = {
  [_securitysolutionUtils.OperatingSystem.LINUX]: 'linux',
  [_securitysolutionUtils.OperatingSystem.MAC]: 'macos',
  [_securitysolutionUtils.OperatingSystem.WINDOWS]: 'windows'
};
const effectScopeToTags = effectScope => {
  if (effectScope.type === 'policy') {
    return effectScope.policies.map(policy => `${_constants.BY_POLICY_ARTIFACT_TAG_PREFIX}${policy}`);
  } else {
    return [`${_constants.BY_POLICY_ARTIFACT_TAG_PREFIX}all`];
  }
};

/**
 * Map NewTrustedApp to CreateExceptionListItemOptions.
 */
const newTrustedAppToCreateExceptionListItem = ({
  os,
  entries,
  name,
  description = '',
  effectScope
}) => {
  return {
    comments: [],
    description,
    entries: (0, _exception_list_items.conditionEntriesToEntries)(entries, true),
    list_id: _securitysolutionListConstants.ENDPOINT_TRUSTED_APPS_LIST_ID,
    meta: undefined,
    name,
    namespace_type: 'agnostic',
    os_types: [OPERATING_SYSTEM_TO_OS_TYPE[os]],
    tags: effectScopeToTags(effectScope),
    type: 'simple'
  };
};
exports.newTrustedAppToCreateExceptionListItem = newTrustedAppToCreateExceptionListItem;