"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryProtection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _constants = require("../../../../../../../common/constants");
var _types = require("../../../../../../app/types");
var _types2 = require("../../../../../../../common/endpoint/types");
var _config_form = require("../../components/config_form");
var _link_to_app = require("../../../../../../common/components/endpoint/link_to_app");
var _radio_buttons = require("../components/radio_buttons");
var _user_notification = require("../components/user_notification");
var _protection_switch = require("../components/protection_switch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The Memory Protections form for policy details
 *  which will configure for all relevant OSes.
 */
const MemoryProtection = /*#__PURE__*/_react.default.memo(() => {
  const OSes = [_types2.PolicyOperatingSystem.windows, _types2.PolicyOperatingSystem.mac, _types2.PolicyOperatingSystem.linux];
  const protection = 'memory_protection';
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.memory', {
    defaultMessage: 'Memory threat protections'
  });
  return /*#__PURE__*/_react.default.createElement(_config_form.ConfigForm, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.memory_protection', {
      defaultMessage: 'Memory threat'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.LINUX],
    dataTestSubj: "memoryProtectionsForm",
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_switch.ProtectionSwitch, {
      protection: protection,
      protectionLabel: protectionLabel,
      osList: OSes
    })
  }, /*#__PURE__*/_react.default.createElement(_radio_buttons.RadioButtons, {
    protection: protection,
    osList: OSes
  }), /*#__PURE__*/_react.default.createElement(_user_notification.UserNotification, {
    protection: protection,
    osList: OSes
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.detectionRulesMessage",
    defaultMessage: "View {detectionRulesLink}. Prebuilt rules are tagged \u201CElastic\u201D on the Detection Rules page.",
    values: {
      detectionRulesLink: /*#__PURE__*/_react.default.createElement(_link_to_app.LinkToApp, {
        appId: _constants.APP_UI_ID,
        deepLinkId: _types.SecurityPageName.rules
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.details.detectionRulesLink",
        defaultMessage: "related detection rules"
      }))
    }
  })));
});
exports.MemoryProtection = MemoryProtection;
MemoryProtection.displayName = 'MemoryProtection';