"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserNotification = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../../common/endpoint/types");
var _config_form = require("../../components/config_form");
var _policy_hooks = require("../../policy_hooks");
var _selectors = require("../../../store/policy_details/selectors");
var _supported_version = require("./supported_version");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserNotification = /*#__PURE__*/_react.default.memo(({
  protection,
  osList
}) => {
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const dispatch = (0, _reactRedux.useDispatch)();
  const selected = policyDetailsConfig && policyDetailsConfig.windows[protection].mode;
  const userNotificationSelected = policyDetailsConfig && policyDetailsConfig.windows.popup[protection].enabled;
  const userNotificationMessage = policyDetailsConfig && policyDetailsConfig.windows.popup[protection].message;
  const handleUserNotificationCheckbox = (0, _react.useCallback)(event => {
    if (policyDetailsConfig) {
      const newPayload = (0, _lodash.cloneDeep)(policyDetailsConfig);
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os].popup[protection].enabled = event.target.checked;
        } else if (os === 'mac') {
          newPayload[os].popup[protection].enabled = event.target.checked;
        } else if (os === 'linux') {
          newPayload[os].popup[protection].enabled = event.target.checked;
        }
      }
      dispatch({
        type: 'userChangedPolicyConfig',
        payload: {
          policyConfig: newPayload
        }
      });
    }
  }, [policyDetailsConfig, dispatch, protection, osList]);
  const handleCustomUserNotification = (0, _react.useCallback)(event => {
    if (policyDetailsConfig) {
      const newPayload = (0, _lodash.cloneDeep)(policyDetailsConfig);
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os].popup[protection].message = event.target.value;
        } else if (os === 'mac') {
          newPayload[os].popup[protection].message = event.target.value;
        } else if (os === 'linux') {
          newPayload[os].popup[protection].message = event.target.value;
        }
      }
      dispatch({
        type: 'userChangedPolicyConfig',
        payload: {
          policyConfig: newPayload
        }
      });
    }
  }, [policyDetailsConfig, dispatch, protection, osList]);
  const tooltipProtectionText = protectionType => {
    if (protectionType === 'memory_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.memoryProtectionTooltip', {
        defaultMessage: 'memory threat'
      });
    } else if (protectionType === 'behavior_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.behaviorProtectionTooltip', {
        defaultMessage: 'malicious behavior'
      });
    } else {
      return protectionType;
    }
  };
  const tooltipBracketText = protectionType => {
    if (protectionType === 'memory_protection' || protection === 'behavior_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.rule', {
        defaultMessage: 'rule'
      });
    } else {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.filename', {
        defaultMessage: 'filename'
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_config_form.ConfigFormHeading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.userNotification",
    defaultMessage: "User notification"
  })), /*#__PURE__*/_react.default.createElement(_supported_version.SupportedVersionNotice, {
    optionName: protection
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": `${protection}UserNotificationCheckbox`,
    id: `${protection}UserNotificationCheckbox}`,
    onChange: handleUserNotificationCheckbox,
    checked: userNotificationSelected,
    disabled: !showEditableFormFields || selected === _types.ProtectionModes.off,
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.notifyUser', {
      defaultMessage: 'Notify user'
    })
  }), userNotificationSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.customizeUserNotification",
    defaultMessage: "Customize notification message"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${protection}TooltipIcon`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    "data-test-subj": `${protection}Tooltip`,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.notifyUserTooltip.a",
      defaultMessage: "Selecting the user notification option will display a notification to the host user when { protectionName } is prevented or detected.",
      values: {
        protectionName: tooltipProtectionText(protection)
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.notifyUserTooltip.c",
      defaultMessage: " The user notification can be customized in the text box below. Bracketed tags can be used to dynamically populate the applicable action (such as prevented or detected) and the { bracketText }.",
      values: {
        bracketText: tooltipBracketText(protection)
      }
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.userNotification.placeholder', {
      defaultMessage: 'Input your custom notification message'
    }),
    value: userNotificationMessage,
    onChange: handleCustomUserNotification,
    fullWidth: true,
    disabled: !showEditableFormFields,
    "data-test-subj": `${protection}UserNotificationCustomMessage`
  })));
});
exports.UserNotification = UserNotification;
UserNotification.displayName = 'UserNotification';