"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_ARTIFACT_FLYOUT_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ARTIFACT_FLYOUT_LABELS = Object.freeze({
  flyoutWarningCalloutTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.searchWarning.title', {
    defaultMessage: 'Limited search results'
  }),
  flyoutWarningCalloutMessage: maxNumber => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.searchWarning.text', {
    defaultMessage: 'Only the first {maxNumber} artifacts are displayed. Please use the search bar to refine the results.',
    values: {
      maxNumber
    }
  }),
  flyoutNoArtifactsToBeAssignedMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.noAssignable', {
    defaultMessage: 'There are no artifacts that can be assigned to this policy.'
  }),
  flyoutNoSearchResultsMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.noResults', {
    defaultMessage: 'No items found'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.title', {
    defaultMessage: 'Assign artifacts'
  }),
  flyoutSubtitle: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.subtitle', {
    defaultMessage: 'Select artifacts to add to {policyName}',
    values: {
      policyName
    }
  }),
  flyoutSearchPlaceholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.search.label', {
    defaultMessage: 'Search artifacts'
  }),
  flyoutCancelButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.cancel', {
    defaultMessage: 'Cancel'
  }),
  flyoutSubmitButtonTitle: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.confirm', {
    defaultMessage: 'Assign to {policyName}',
    values: {
      policyName
    }
  }),
  flyoutErrorMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.toastError.text', {
    defaultMessage: `An error occurred updating artifacts`
  }),
  flyoutSuccessMessageTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.toastSuccess.title', {
    defaultMessage: 'Success'
  }),
  flyoutSuccessMessageText: updatedExceptions => updatedExceptions.length > 1 ? _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.toastSuccess.textMultiples', {
    defaultMessage: '{count} artifacts have been added to your list.',
    values: {
      count: updatedExceptions.length
    }
  }) : _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.layout.flyout.toastSuccess.textSingle', {
    defaultMessage: '"{name}" has been added to your artifacts list.',
    values: {
      name: updatedExceptions[0].name
    }
  })
});
exports.POLICY_ARTIFACT_FLYOUT_LABELS = POLICY_ARTIFACT_FLYOUT_LABELS;