"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _hooks = require("../hooks");
var _selectors = require("../../store/selectors");
var _routing = require("../../../../common/routing");
var _endpoint_details = require("./endpoint_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointDetailsFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const history = (0, _reactRouterDom.useHistory)();
  const queryParams = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const {
    selected_endpoint: selectedEndpoint,
    ...queryParamsWithoutSelectedEndpoint
  } = queryParams;
  const handleFlyoutClose = (0, _react.useCallback)(() => {
    const {
      show: _show,
      ...urlSearchParams
    } = queryParamsWithoutSelectedEndpoint;
    history.push((0, _routing.getEndpointListPath)({
      name: 'endpointList',
      ...urlSearchParams
    }));
  }, [history, queryParamsWithoutSelectedEndpoint]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleFlyoutClose,
    "data-test-subj": "endpointDetailsFlyout",
    size: "m",
    paddingSize: "l",
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_endpoint_details.EndpointDetails, null));
});
exports.EndpointDetailsFlyout = EndpointDetailsFlyout;
EndpointDetailsFlyout.displayName = 'EndpointDetailsFlyout';