"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockListForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _lodash = require("lodash");
var _translations = require("../../../../common/translations");
var _translations2 = require("../../translations");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _constants = require("../../../../../../common/endpoint/service/artifacts/constants");
var _use_license = require("../../../../../common/hooks/use_license");
var _validations = require("../../../../../../common/endpoint/service/artifacts/validations");
var _artifacts = require("../../../../../../common/endpoint/service/artifacts");
var _utils = require("../../../../components/effected_policy_select/utils");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const testIdPrefix = 'blocklist-form';
function createValidationMessage(message) {
  return /*#__PURE__*/_react.default.createElement("div", null, message);
}
function getDropdownDisplay(field) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.CONDITION_FIELD_TITLE[field], /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _translations2.CONDITION_FIELD_DESCRIPTION[field]));
}
function isValid(itemValidation) {
  return !Object.values(itemValidation).some(errors => Object.keys(errors).length);
}
const BlockListForm = /*#__PURE__*/(0, _react.memo)(({
  item,
  policies,
  policiesIsLoading,
  onChange,
  mode
}) => {
  const [visited, setVisited] = (0, _react.useState)({
    name: false,
    value: false
  });
  const warningsRef = (0, _react.useRef)({
    name: {},
    value: {}
  });
  const errorsRef = (0, _react.useRef)({
    name: {},
    value: {}
  });
  const [selectedPolicies, setSelectedPolicies] = (0, _react.useState)([]);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isGlobal = (0, _react.useMemo)(() => (0, _artifacts.isArtifactGlobal)(item), [item]);
  const [wasByPolicy, setWasByPolicy] = (0, _react.useState)(!(0, _utils.isGlobalPolicyEffected)(item.tags));
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  const showAssignmentSection = (0, _react.useMemo)(() => {
    return isPlatinumPlus || mode === 'edit' && (!isGlobal || wasByPolicy && isGlobal && hasFormChanged);
  }, [mode, isGlobal, hasFormChanged, isPlatinumPlus, wasByPolicy]);

  // set initial state of `wasByPolicy` that checks if the initial state of the exception was by policy or not
  (0, _react.useEffect)(() => {
    if (!hasFormChanged && item.tags) {
      setWasByPolicy(!(0, _utils.isGlobalPolicyEffected)(item.tags));
    }
  }, [item.tags, hasFormChanged]);

  // select policies if editing
  (0, _react.useEffect)(() => {
    var _item$tags$map, _item$tags;
    if (hasFormChanged) return;
    const policyIds = (_item$tags$map = (_item$tags = item.tags) === null || _item$tags === void 0 ? void 0 : _item$tags.map(tag => tag.split(':')[1])) !== null && _item$tags$map !== void 0 ? _item$tags$map : [];
    if (!policyIds.length) return;
    const policiesData = policies.filter(policy => policyIds.includes(policy.id));
    setSelectedPolicies(policiesData);
  }, [hasFormChanged, item.tags, policies]);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(testIdPrefix);
  const blocklistEntry = (0, _react.useMemo)(() => {
    if (!item.entries.length) {
      return {
        field: 'file.hash.*',
        operator: 'included',
        type: 'match_any',
        value: []
      };
    }
    return item.entries[0];
  }, [item.entries]);
  const selectedOs = (0, _react.useMemo)(() => {
    var _item$os_types;
    if (!(item !== null && item !== void 0 && (_item$os_types = item.os_types) !== null && _item$os_types !== void 0 && _item$os_types.length)) {
      return _securitysolutionUtils.OperatingSystem.WINDOWS;
    }
    return item.os_types[0];
  }, [item === null || item === void 0 ? void 0 : item.os_types]);
  const selectedValues = (0, _react.useMemo)(() => {
    return blocklistEntry.value.map(label => ({
      label,
      'data-test-subj': getTestId(`values-input-${label}`)
    }));
  }, [blocklistEntry.value, getTestId]);
  const osOptions = (0, _react.useMemo)(() => [_securitysolutionUtils.OperatingSystem.LINUX, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.WINDOWS].map(os => ({
    value: os,
    inputDisplay: _translations.OS_TITLES[os]
  })), []);
  const fieldOptions = (0, _react.useMemo)(() => {
    const selectableFields = ['file.hash.*', 'file.path'].map(field => ({
      value: field,
      inputDisplay: _translations2.CONDITION_FIELD_TITLE[field],
      dropdownDisplay: getDropdownDisplay(field),
      'data-test-subj': getTestId(field)
    }));
    if (selectedOs === _securitysolutionUtils.OperatingSystem.WINDOWS) {
      selectableFields.push({
        value: 'file.Ext.code_signature',
        inputDisplay: _translations2.CONDITION_FIELD_TITLE['file.Ext.code_signature'],
        dropdownDisplay: getDropdownDisplay('file.Ext.code_signature'),
        'data-test-subj': getTestId('file.Ext.code_signature')
      });
    }
    return selectableFields;
  }, [selectedOs, getTestId]);
  const valueLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations2.VALUE_LABEL_HELPER
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.VALUE_LABEL, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "iInCircle",
      className: "eui-alignTop"
    }))));
  }, []);
  const validateValues = (0, _react.useCallback)(nextItem => {
    var _ref, _nextItem$os_types, _nextItem$entries$;
    const os = (_ref = ((_nextItem$os_types = nextItem.os_types) !== null && _nextItem$os_types !== void 0 ? _nextItem$os_types : [])[0]) !== null && _ref !== void 0 ? _ref : _securitysolutionUtils.OperatingSystem.WINDOWS;
    const {
      field = 'file.hash.*',
      type = 'match_any',
      value: values = []
    } = (_nextItem$entries$ = nextItem.entries[0]) !== null && _nextItem$entries$ !== void 0 ? _nextItem$entries$ : {};
    const newValueWarnings = {};
    const newNameErrors = {};
    const newValueErrors = {};

    // error if name empty
    if (!nextItem.name.trim()) {
      newNameErrors.NAME_REQUIRED = createValidationMessage(_translations2.ERRORS.NAME_REQUIRED);
    }

    // error if no values
    if (!values.length) {
      newValueErrors.VALUE_REQUIRED = createValidationMessage(_translations2.ERRORS.VALUE_REQUIRED);
    }

    // error if invalid hash
    if (field === 'file.hash.*' && values.some(value => !(0, _validations.isValidHash)(value))) {
      newValueErrors.INVALID_HASH = createValidationMessage(_translations2.ERRORS.INVALID_HASH);
    }
    const isInvalidPath = values.some(value => !(0, _securitysolutionUtils.isPathValid)({
      os,
      field,
      type,
      value
    }));

    // warn if invalid path
    if (field !== 'file.hash.*' && isInvalidPath) {
      newValueWarnings.INVALID_PATH = createValidationMessage(_translations2.ERRORS.INVALID_PATH);
    }

    // warn if duplicates
    if (values.length !== (0, _lodash.uniq)(values).length) {
      newValueWarnings.DUPLICATE_VALUES = createValidationMessage(_translations2.ERRORS.DUPLICATE_VALUES);
    }
    warningsRef.current = {
      ...warningsRef.current,
      value: newValueWarnings
    };
    errorsRef.current = {
      name: newNameErrors,
      value: newValueErrors
    };
  }, []);
  const handleOnNameBlur = (0, _react.useCallback)(() => {
    validateValues(item);
    setVisited(prevVisited => ({
      ...prevVisited,
      name: true
    }));
  }, [item, validateValues]);
  const handleOnValueBlur = (0, _react.useCallback)(() => {
    validateValues(item);
    setVisited(prevVisited => ({
      ...prevVisited,
      value: true
    }));
  }, [item, validateValues]);
  const handleOnNameChange = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      name: event.target.value
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item]);
  const handleOnDescriptionChange = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      description: event.target.value
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [onChange, item, validateValues]);
  const handleOnOsChange = (0, _react.useCallback)(os => {
    const nextItem = {
      ...item,
      os_types: [os],
      entries: [{
        ...blocklistEntry,
        field: os !== _securitysolutionUtils.OperatingSystem.WINDOWS && blocklistEntry.field === 'file.Ext.code_signature' ? 'file.hash.*' : blocklistEntry.field
      }]
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, blocklistEntry, onChange, item]);
  const handleOnFieldChange = (0, _react.useCallback)(field => {
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        field
      }]
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item, blocklistEntry]);
  const handleOnValueTextChange = (0, _react.useCallback)(value => {
    const nextWarnings = {
      ...warningsRef.current.value
    };
    if (blocklistEntry.value.includes(value)) {
      nextWarnings.DUPLICATE_VALUE = createValidationMessage(_translations2.ERRORS.DUPLICATE_VALUE);
    } else {
      delete nextWarnings.DUPLICATE_VALUE;
    }
    warningsRef.current = {
      ...warningsRef.current,
      value: nextWarnings
    };

    // trigger re-render without modifying item
    setVisited(prevVisited => ({
      ...prevVisited
    }));
  }, [blocklistEntry]);

  // only triggered on remove / clear
  const handleOnValueChange = (0, _react.useCallback)(change => {
    const value = change.map(option => option.label);
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        value
      }]
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item, blocklistEntry]);
  const handleOnValueAdd = (0, _react.useCallback)(option => {
    const splitValues = option.split(',').filter(value => value.trim());
    const value = [...blocklistEntry.value, ...splitValues];
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        value
      }]
    };
    validateValues(nextItem);
    nextItem.entries[0].value = (0, _lodash.uniq)(nextItem.entries[0].value);
    setVisited(prevVisited => ({
      ...prevVisited,
      value: true
    }));
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item, blocklistEntry]);
  const handleOnPolicyChange = (0, _react.useCallback)(change => {
    const tags = change.isGlobal ? [_constants.GLOBAL_ARTIFACT_TAG] : change.selected.map(policy => `${_constants.BY_POLICY_ARTIFACT_TAG_PREFIX}${policy.id}`);
    const nextItem = {
      ...item,
      tags
    };

    // Preserve old selected policies when switching to global
    if (!change.isGlobal) {
      setSelectedPolicies(change.selected);
    }
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations2.DETAILS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), mode === 'create' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('header-description')
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations2.DETAILS_HEADER_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.NAME_LABEL,
    isInvalid: visited.name && !!Object.keys(errorsRef.current.name).length,
    error: Object.values(errorsRef.current.name),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    value: item.name,
    onChange: handleOnNameChange,
    onBlur: handleOnNameBlur,
    required: visited.name,
    maxLength: 256,
    "data-test-subj": getTestId('name-input'),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.DESCRIPTION_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: item.description,
    onChange: handleOnDescriptionChange,
    "data-test-subj": getTestId('description-input'),
    fullWidth: true,
    compressed: true,
    maxLength: 256
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations2.CONDITIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations2.CONDITIONS_HEADER_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.SELECT_OS_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "os",
    options: osOptions,
    valueOfSelected: selectedOs,
    onChange: handleOnOsChange,
    "data-test-subj": getTestId('os-select'),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.FIELD_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "field",
    options: fieldOptions,
    valueOfSelected: blocklistEntry.field,
    onChange: handleOnFieldChange,
    "data-test-subj": getTestId('field-select'),
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.OPERATOR_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "operator",
    value: _securitysolutionListUtils.isOneOfOperator.message,
    readOnly: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: valueLabel,
    isInvalid: visited.value && !!Object.keys(errorsRef.current.value).length,
    helpText: Object.values(warningsRef.current.value),
    error: Object.values(errorsRef.current.value),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: selectedValues,
    onBlur: handleOnValueBlur,
    onSearchChange: handleOnValueTextChange,
    onChange: handleOnValueChange,
    onCreateOption: handleOnValueAdd,
    "data-test-subj": getTestId('values-input'),
    fullWidth: true,
    noSuggestions: true
  })), showAssignmentSection && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    isGlobal: isGlobal,
    isPlatinumPlus: isPlatinumPlus,
    selected: selectedPolicies,
    options: policies,
    onChange: handleOnPolicyChange,
    isLoading: policiesIsLoading,
    description: _translations2.POLICY_SELECT_DESCRIPTION,
    "data-test-subj": getTestId('effectedPolicies')
  }))));
});
exports.BlockListForm = BlockListForm;