"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _actions_log_date_range_picker = require("./actions_log_date_range_picker");
var _actions_log_filter = require("./actions_log_filter");
var _actions_log_users_filter = require("./actions_log_users_filter");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsLogFilters = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  isFlyout,
  onClick,
  onChangeHostsFilter,
  onChangeCommandsFilter,
  onChangeStatusesFilter,
  onChangeUsersFilter,
  onChangeTypeFilter,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  showHostsFilter,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const responseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const filters = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showHostsFilter && /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'hosts',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeHostsFilter,
      "data-test-subj": dataTestSubj
    }), /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'actions',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeCommandsFilter,
      "data-test-subj": dataTestSubj
    }), /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'statuses',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeStatusesFilter,
      "data-test-subj": dataTestSubj
    }), responseActionsEnabled && /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'type',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeTypeFilter,
      "data-test-subj": dataTestSubj
    }));
  }, [dataTestSubj, isFlyout, onChangeCommandsFilter, onChangeHostsFilter, onChangeTypeFilter, onChangeStatusesFilter, responseActionsEnabled, showHostsFilter]);
  const onClickRefreshButton = (0, _react.useCallback)(() => onClick(), [onClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isFlyout ? 1 : 2
  }, /*#__PURE__*/_react.default.createElement(_actions_log_users_filter.ActionsLogUsersFilter, {
    isFlyout: isFlyout,
    onChangeUsersFilter: onChangeUsersFilter,
    "data-test-subj": dataTestSubj
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isFlyout ? 1 : 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, filters)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isFlyout ? 1 : 2
  }, /*#__PURE__*/_react.default.createElement(_actions_log_date_range_picker.ActionLogDateRangePicker, {
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isDataLoading,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    "data-test-subj": dataTestSubj
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperUpdateButton, {
    iconOnly: true,
    "data-test-subj": getTestId('super-refresh-button'),
    fill: false,
    isLoading: isDataLoading,
    onClick: onClickRefreshButton
  })));
});
exports.ActionsLogFilters = ActionsLogFilters;
ActionsLogFilters.displayName = 'ActionsLogFilters';