"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _unsupported_message_callout = require("./unsupported_message_callout");
var _command_usage = require("./command_usage");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _console_code_block = require("./console_code_block");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shows a validation error. The error message needs to be defined via the Command defintion's
 * `validate`
 */
const ValidationError = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStatus,
  store
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  (0, _react.useEffect)(() => {
    setStatus('success');
  }, [setStatus]);
  return /*#__PURE__*/_react.default.createElement(_unsupported_message_callout.UnsupportedMessageCallout, {
    header: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      textColor: "error"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.validationError.title",
      defaultMessage: "Unsupported action"
    })),
    "data-test-subj": getTestId('validationError')
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('validationError-message')
  }, store.errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_command_usage.CommandInputUsage, {
    commandDef: command.commandDefinition
  }), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.console.validationError.helpMessage",
    defaultMessage: "Enter {helpCmd} for further assistance.",
    values: {
      helpCmd: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        bold: true,
        inline: true
      }, `${command.commandDefinition.name} --help`)
    }
  })));
});
exports.ValidationError = ValidationError;
ValidationError.displayName = 'ValidationError';