"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConsoleStore = exports.ConsoleStateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_stored_input_history = require("./hooks/use_stored_input_history");
var _console_manager = require("../console_manager/console_manager");
var _state_reducer = require("./state_reducer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConsoleStateContext = /*#__PURE__*/(0, _react.createContext)(null);
/**
 * A Console wide data store for internal state management between inner components
 */
const ConsoleStateProvider = /*#__PURE__*/(0, _react.memo)(({
  commands,
  scrollToBottom,
  keyCapture,
  HelpComponent,
  dataTestSubj,
  storagePrefix,
  managedKey,
  children
}) => {
  const [getConsoleState, storeConsoleState] = (0, _console_manager.useWithManagedConsoleState)(managedKey);
  const storedInputHistoryData = (0, _use_stored_input_history.useStoredInputHistory)(storagePrefix);
  const saveInputHistoryData = (0, _use_stored_input_history.useSaveInputHistoryToStorage)(storagePrefix);
  const stateInitializer = (0, _react.useCallback)(stateInit => {
    const createdInitState = (0, _state_reducer.initiateState)(stateInit, getConsoleState ? getConsoleState() : undefined);
    createdInitState.input.history = storedInputHistoryData;
    return createdInitState;
  }, [getConsoleState, storedInputHistoryData]);
  const [state, dispatch] = (0, _react.useReducer)(_state_reducer.stateDataReducer, {
    commands,
    scrollToBottom,
    keyCapture,
    HelpComponent,
    dataTestSubj,
    storagePrefix
  }, stateInitializer);

  // Anytime `state` changes AND the console is under ConsoleManager's control, then
  // store the console's state to ConsoleManager. This is what enables a console to be
  // closed/re-opened while maintaining the console's content
  (0, _react.useEffect)(() => {
    if (storeConsoleState) {
      storeConsoleState(state);
    }
  }, [state, storeConsoleState]);

  // Anytime `input.history` changes and a `storagePrefix` is defined, then persist
  // the input history to storage
  (0, _react.useEffect)(() => {
    if (storagePrefix && state.input.history) {
      saveInputHistoryData(state.input.history);
    }
  }, [saveInputHistoryData, state.input.history, storagePrefix]);
  return /*#__PURE__*/_react.default.createElement(ConsoleStateContext.Provider, {
    value: {
      state,
      dispatch
    }
  }, children);
});
exports.ConsoleStateProvider = ConsoleStateProvider;
ConsoleStateProvider.displayName = 'ConsoleStateProvider';
const useConsoleStore = () => {
  const store = (0, _react.useContext)(ConsoleStateContext);
  if (!store) {
    throw new Error(`ConsoleStateContext not defined`);
  }
  return store;
};
exports.useConsoleStore = useConsoleStore;