"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandUsage = exports.CommandInputUsage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _console_code_block = require("./console_code_block");
var _parsed_command_input = require("../service/parsed_command_input");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _unsupported_message_callout = require("./unsupported_message_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const additionalProps = {
  className: 'euiTruncateText'
};
const CommandInputUsage = /*#__PURE__*/(0, _react.memo)(({
  commandDef
}) => {
  const usageHelp = (0, _react.useMemo)(() => {
    return (0, _parsed_command_input.getArgumentsForCommand)(commandDef).map((usage, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: `helpUsage-${index}`
      }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, `${commandDef.name} ${usage}`));
    });
  }, [commandDef]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    className: "descriptionList-20_80",
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.inputUsage', {
        defaultMessage: 'Usage'
      })),
      description: usageHelp && usageHelp.length > 0 ? usageHelp : commandDef.name
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), commandDef.exampleUsage && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    className: "descriptionList-20_80",
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.exampleUsage', {
        defaultMessage: 'Example'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, commandDef.exampleUsage)
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps
  }));
});
exports.CommandInputUsage = CommandInputUsage;
CommandInputUsage.displayName = 'CommandInputUsage';
const CommandUsage = /*#__PURE__*/(0, _react.memo)(({
  commandDef,
  errorMessage
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const hasArgs = (0, _react.useMemo)(() => {
    var _commandDef$args;
    return Object.keys((_commandDef$args = commandDef.args) !== null && _commandDef$args !== void 0 ? _commandDef$args : []).length > 0;
  }, [commandDef.args]);
  const commandOptions = (0, _react.useMemo)(() => {
    if (!hasArgs || !commandDef.args) {
      return {
        required: [],
        exclusiveOr: [],
        optional: []
      };
    }
    const enteredCommands = Object.entries(commandDef.args).reduce((acc, curr) => {
      const item = {
        title: `--${curr[0]}`,
        description: curr[1].about
      };
      if (curr[1].required) {
        acc.required.push(item);
      } else if (curr[1].exclusiveOr) {
        acc.exclusiveOr.push(item);
      } else {
        acc.optional.push(item);
      }
      return acc;
    }, {
      required: [],
      exclusiveOr: [],
      optional: []
    });
    return enteredCommands;
  }, [commandDef.args, hasArgs]);
  const parametersDescriptionList = (title, parameters) => {
    const description = parameters.map(item => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      bold: true,
      inline: true
    }, item.title), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      inline: true
    }, ' - ', item.description)));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), commandDef.args && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: "column",
      className: "descriptionList-20_80",
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, title),
        description
      }],
      descriptionProps: additionalProps,
      titleProps: additionalProps,
      "data-test-subj": getTestId('commandUsage-options')
    }));
  };
  const renderErrorMessage = (0, _react.useCallback)(() => {
    if (!errorMessage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_unsupported_message_callout.UnsupportedMessageCallout, {
      header: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        textColor: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.validationError.title",
        defaultMessage: "Unsupported action"
      })),
      "data-test-subj": getTestId('validationError')
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId('badArgument-message')
    }, errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }, [errorMessage, getTestId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": getTestId('commandUsage')
  }, renderErrorMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    className: "descriptionList-20_80",
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.about', {
        defaultMessage: 'About'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, commandDef.about)
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    "data-test-subj": getTestId('commandUsage-options')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(CommandInputUsage, {
    commandDef: commandDef
  }), commandOptions.required && commandOptions.required.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.requiredLabel', {
    defaultMessage: 'Required parameters'
  }), commandOptions.required), commandOptions.exclusiveOr && commandOptions.exclusiveOr.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.exclusiveOr', {
    defaultMessage: 'Include only one parameter'
  }), commandOptions.exclusiveOr), commandOptions.optional && commandOptions.optional.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.optional', {
    defaultMessage: 'Optional parameters'
  }), commandOptions.optional));
});
exports.CommandUsage = CommandUsage;
CommandUsage.displayName = 'CommandUsage';