"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithArtifactDeleteItem = exports.ARTIFACT_DELETE_ACTION_LABELS = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _artifacts = require("../../../hooks/artifacts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARTIFACT_DELETE_ACTION_LABELS = Object.freeze({
  /**
   * Message to be displayed in toast when deletion fails
   * @param itemName
   * @param errorMessage
   * @example
   * (itemsName, errorMessage) => i18n.translate(
   *    'xpack.securitySolution.artifactListPage.deleteActionFailure',
   *    {
   *      defaultMessage: 'Unable to remove "{itemName}" . Reason: {errorMessage}',
   *      values: { itemName, errorMessage },
   *    })
   */
  deleteActionFailure: (itemName, errorMessage) => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteActionFailure', {
    defaultMessage: 'Unable to remove "{itemName}". Reason: {errorMessage}',
    values: {
      itemName,
      errorMessage
    }
  }),
  /**
   * Message to be displayed in the toast after a successful delete
   * @param itemName
   * @example
   *  (itemName) => i18n.translate('xpack.securitySolution.some_page.deleteSuccess', {
   *    defaultMessage: '"{itemName}" has been removed',
   *    values: { itemName },
   *  })
   */
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteActionSuccess', {
    defaultMessage: '"{itemName}" has been removed',
    values: {
      itemName
    }
  })
});
exports.ARTIFACT_DELETE_ACTION_LABELS = ARTIFACT_DELETE_ACTION_LABELS;
const useWithArtifactDeleteItem = (apiClient, item, labels) => {
  const toasts = (0, _kibana.useToasts)();
  const deleteArtifact = (0, _artifacts.useDeleteArtifact)(apiClient, {
    onError: error => {
      var _error$body;
      toasts.addDanger(labels.deleteActionFailure(item.name, ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message));
    },
    onSuccess: response => {
      toasts.addSuccess(labels.deleteActionSuccess(response.name));
    }
  });
  return (0, _react.useMemo)(() => {
    return {
      ...deleteArtifact,
      deleteArtifactItem: deleteArtifact.mutateAsync
    };
  }, [deleteArtifact]);
};
exports.useWithArtifactDeleteItem = useWithArtifactDeleteItem;