"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _administration_list_page = require("../administration_list_page");
var _paginated_content = require("../paginated_content");
var _artifact_entry_card = require("../artifact_entry_card");
var _translations = require("./translations");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _management_page_loader = require("../management_page_loader");
var _search_exceptions = require("../search_exceptions");
var _use_artifact_card_props_provider = require("./hooks/use_artifact_card_props_provider");
var _no_data_empty_state = require("./components/no_data_empty_state");
var _artifact_flyout = require("./components/artifact_flyout");
var _use_is_flyout_opened = require("./hooks/use_is_flyout_opened");
var _use_set_url_params = require("./hooks/use_set_url_params");
var _use_with_artifact_list_data = require("./hooks/use_with_artifact_list_data");
var _use_url_params = require("../../hooks/use_url_params");
var _constants = require("../../../../common/endpoint/service/artifacts/constants");
var _artifact_delete_modal = require("./components/artifact_delete_modal");
var _hooks = require("../../services/policies/hooks");
var _translations2 = require("../../common/translations");
var _kibana = require("../../../common/lib/kibana");
var _hooks2 = require("../../common/hooks");
var _back_to_external_app_secondary_button = require("../back_to_external_app_secondary_button");
var _back_to_external_app_button = require("../back_to_external_app_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ArtifactListPage = /*#__PURE__*/(0, _react.memo)(({
  apiClient,
  ArtifactFormComponent,
  searchableFields = _constants.DEFAULT_EXCEPTION_LIST_ITEM_SEARCHABLE_FIELDS,
  labels: _labels = {},
  secondaryPageInfo,
  onFormSubmit,
  flyoutSize,
  'data-test-subj': dataTestSubj,
  allowCardEditAction = true,
  allowCardCreateAction = true,
  allowCardDeleteAction = true
}) => {
  var _policiesRequest$data, _policiesRequest$data2;
  const {
    state: routeState
  } = (0, _reactRouterDom.useLocation)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const toasts = (0, _kibana.useToasts)();
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const isFlyoutOpened = (0, _use_is_flyout_opened.useIsFlyoutOpened)(allowCardEditAction, allowCardCreateAction);
  const setUrlParams = (0, _use_set_url_params.useSetUrlParams)();
  const {
    urlParams: {
      filter,
      includedPolicies
    }
  } = (0, _use_url_params.useUrlParams)();
  const {
    isPageInitializing,
    isFetching: isLoading,
    data: listDataResponse,
    uiPagination,
    doesDataExist,
    error,
    refetch: refetchListData
  } = (0, _use_with_artifact_list_data.useWithArtifactListData)(apiClient, searchableFields);
  (0, _react.useEffect)(() => {
    if (!isLoading && error) {
      var _error$body;
      toasts.addDanger((error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message);
    }
  }, [error, toasts, isLoading]);
  const items = (0, _react.useMemo)(() => {
    var _listDataResponse$dat;
    return (_listDataResponse$dat = listDataResponse === null || listDataResponse === void 0 ? void 0 : listDataResponse.data) !== null && _listDataResponse$dat !== void 0 ? _listDataResponse$dat : [];
  }, [listDataResponse === null || listDataResponse === void 0 ? void 0 : listDataResponse.data]);
  const [selectedItemForDelete, setSelectedItemForDelete] = (0, _react.useState)(undefined);
  const [selectedItemForEdit, setSelectedItemForEdit] = (0, _react.useState)(undefined);
  const labels = (0, _react.useMemo)(() => {
    return {
      ..._translations.artifactListPageLabels,
      ..._labels
    };
  }, [_labels]);
  const handleOnCardActionClick = (0, _react.useCallback)(({
    type,
    item
  }) => {
    switch (type) {
      case 'edit':
        setSelectedItemForEdit(item);
        setUrlParams({
          show: 'edit',
          itemId: item.item_id
        });
        break;
      case 'delete':
        setSelectedItemForDelete(item);
        break;
    }
  }, [setUrlParams]);
  const handleCardProps = (0, _use_artifact_card_props_provider.useArtifactCardPropsProvider)({
    items,
    onAction: handleOnCardActionClick,
    cardActionDeleteLabel: labels.cardActionDeleteLabel,
    cardActionEditLabel: labels.cardActionEditLabel,
    dataTestSubj: getTestId('card'),
    allowCardDeleteAction,
    allowCardEditAction
  });
  const policiesRequest = (0, _hooks.useGetEndpointSpecificPolicies)({
    onError: err => {
      toasts.addWarning((0, _translations2.getLoadPoliciesError)(err));
    }
  });
  const memoizedRouteState = (0, _hooks2.useMemoizedRouteState)(routeState);
  const backButtonEmptyComponent = (0, _react.useMemo)(() => {
    if (memoizedRouteState && memoizedRouteState.onBackButtonNavigateTo) {
      return /*#__PURE__*/_react.default.createElement(_back_to_external_app_secondary_button.BackToExternalAppSecondaryButton, memoizedRouteState);
    }
  }, [memoizedRouteState]);
  const backButtonHeaderComponent = (0, _react.useMemo)(() => {
    if (memoizedRouteState && memoizedRouteState.onBackButtonNavigateTo) {
      return /*#__PURE__*/_react.default.createElement(_back_to_external_app_button.BackToExternalAppButton, memoizedRouteState);
    }
  }, [memoizedRouteState]);
  const handleOpenCreateFlyoutClick = (0, _react.useCallback)(() => {
    setUrlParams({
      show: 'create'
    });
  }, [setUrlParams]);
  const handlePaginationChange = (0, _react.useCallback)(({
    pageIndex,
    pageSize
  }) => {
    setUrlParams({
      page: pageIndex + 1,
      pageSize
    });

    // Scroll to the top to ensure that when new set of data is received and list updated,
    // the user is back at the top of the list
    window.scrollTo({
      top: 0,
      left: 0,
      behavior: 'smooth'
    });
  }, [setUrlParams]);
  const handleOnSearch = (0, _react.useCallback)((filterValue, selectedPolicies, doHardRefresh) => {
    const didFilterChange = filterValue !== (filter !== null && filter !== void 0 ? filter : '') || selectedPolicies !== (includedPolicies !== null && includedPolicies !== void 0 ? includedPolicies : '');
    setUrlParams({
      // `undefined` will drop the param from the url
      filter: filterValue.trim() === '' ? undefined : filterValue,
      includedPolicies: selectedPolicies.trim() === '' ? undefined : selectedPolicies
    });

    // We don't want to trigger a refresh of the list twice because the URL above was already
    // updated, so if the user explicitly clicked the `Refresh` button and nothing has changed
    // in the filter, then trigger a refresh (since the url update did not actually trigger one)
    if (doHardRefresh && !didFilterChange) {
      refetchListData();
    }
  }, [filter, includedPolicies, refetchListData, setUrlParams]);
  const handleArtifactDeleteModalOnSuccess = (0, _react.useCallback)(() => {
    if (isMounted()) {
      setSelectedItemForDelete(undefined);
      refetchListData();
    }
  }, [isMounted, refetchListData]);
  const handleArtifactDeleteModalOnCancel = (0, _react.useCallback)(() => {
    setSelectedItemForDelete(undefined);
  }, []);
  const handleArtifactFlyoutOnSuccess = (0, _react.useCallback)(() => {
    setSelectedItemForEdit(undefined);
    refetchListData();
  }, [refetchListData]);
  const handleArtifactFlyoutOnClose = (0, _react.useCallback)(() => {
    setSelectedItemForEdit(undefined);
  }, []);
  const description = (0, _react.useMemo)(() => {
    const subtitleText = labels.pageAboutInfo ? /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "header-panel-subtitle"
    }, labels.pageAboutInfo) : undefined;
    const detailedPageInfoElement = secondaryPageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), secondaryPageInfo) : undefined;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, subtitleText, detailedPageInfoElement);
  }, [labels.pageAboutInfo, secondaryPageInfo]);
  if (isPageInitializing) {
    return /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
      "data-test-subj": getTestId('pageLoader')
    });
  }
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    headerBackComponent: backButtonHeaderComponent,
    hideHeader: !doesDataExist,
    title: labels.pageTitle,
    subtitle: description,
    actions: allowCardCreateAction && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "plusInCircle",
      isDisabled: isFlyoutOpened,
      onClick: handleOpenCreateFlyoutClick,
      "data-test-subj": getTestId('pageAddButton')
    }, labels.pageAddButtonTitle),
    "data-test-subj": getTestId('container')
  }, isFlyoutOpened && /*#__PURE__*/_react.default.createElement(_artifact_flyout.ArtifactFlyout, {
    apiClient: apiClient,
    item: selectedItemForEdit,
    onSuccess: handleArtifactFlyoutOnSuccess,
    onClose: handleArtifactFlyoutOnClose,
    FormComponent: ArtifactFormComponent,
    labels: labels,
    size: flyoutSize,
    submitHandler: onFormSubmit,
    policies: ((_policiesRequest$data = policiesRequest.data) === null || _policiesRequest$data === void 0 ? void 0 : _policiesRequest$data.items) || [],
    policiesIsLoading: policiesRequest.isLoading,
    "data-test-subj": getTestId('flyout')
  }), selectedItemForDelete && /*#__PURE__*/_react.default.createElement(_artifact_delete_modal.ArtifactDeleteModal, {
    apiClient: apiClient,
    item: selectedItemForDelete,
    labels: labels,
    "data-test-subj": getTestId('deleteModal'),
    onSuccess: handleArtifactDeleteModalOnSuccess,
    onCancel: handleArtifactDeleteModalOnCancel
  }), !doesDataExist ? /*#__PURE__*/_react.default.createElement(_no_data_empty_state.NoDataEmptyState, {
    onAdd: handleOpenCreateFlyoutClick,
    titleNoEntriesLabel: labels.emptyStateTitleNoEntries,
    titleLabel: labels.emptyStateTitle,
    aboutInfo: labels.emptyStateInfo,
    primaryButtonLabel: labels.emptyStatePrimaryButtonLabel,
    backComponent: backButtonEmptyComponent,
    "data-test-subj": getTestId('emptyState'),
    secondaryAboutInfo: secondaryPageInfo,
    canCreateItems: allowCardCreateAction
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_exceptions.SearchExceptions, {
    defaultValue: filter,
    onSearch: handleOnSearch,
    placeholder: labels.searchPlaceholderInfo,
    hasPolicyFilter: true,
    policyList: (_policiesRequest$data2 = policiesRequest.data) === null || _policiesRequest$data2 === void 0 ? void 0 : _policiesRequest$data2.items,
    defaultIncludedPolicies: includedPolicies
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": getTestId('showCount')
  }, labels.getShowingCountLabel(uiPagination.totalItemCount)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_paginated_content.PaginatedContent, {
    items: items,
    ItemComponent: _artifact_entry_card.ArtifactEntryCard,
    itemComponentProps: handleCardProps,
    onChange: handlePaginationChange,
    error: error,
    loading: isLoading,
    pagination: uiPagination,
    contentClassName: "card-container",
    "data-test-subj": getTestId('list')
  })));
});
exports.ArtifactListPage = ArtifactListPage;
ArtifactListPage.displayName = 'ArtifactListPage';