"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CriteriaConditions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _translations = require("./translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OS_LABELS = Object.freeze({
  linux: _translations.OS_LINUX,
  mac: _translations.OS_MAC,
  macos: _translations.OS_MAC,
  windows: _translations.OS_WINDOWS
});
const OPERATOR_TYPE_LABELS_INCLUDED = Object.freeze({
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.NESTED]: _translations.CONDITION_OPERATOR_TYPE_NESTED,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY]: _translations.CONDITION_OPERATOR_TYPE_MATCH_ANY,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH]: _translations.CONDITION_OPERATOR_TYPE_MATCH,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD]: _translations.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS]: _translations.CONDITION_OPERATOR_TYPE_EXISTS,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST]: _translations.CONDITION_OPERATOR_TYPE_LIST
});
const OPERATOR_TYPE_LABELS_EXCLUDED = Object.freeze({
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY]: _translations.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH]: _translations.CONDITION_OPERATOR_TYPE_NOT_MATCH
});
const EuiFlexGroupNested = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeXL};
`;
const EuiFlexItemNested = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-bottom: 6px !important;
  margin-top: 6px !important;
`;
const StyledCondition = (0, _styledComponents.default)('span')`
  margin-right: 6px;
`;
const CriteriaConditions = /*#__PURE__*/(0, _react.memo)(({
  os,
  entries,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const osLabel = (0, _react.useMemo)(() => {
    return os.map(osValue => {
      var _OS_LABELS;
      return (_OS_LABELS = OS_LABELS[osValue]) !== null && _OS_LABELS !== void 0 ? _OS_LABELS : osValue;
    }).join(', ');
  }, [os]);
  const getEntryValue = (type, value) => {
    if (type === 'match_any' && Array.isArray(value)) {
      return value.map(currentValue => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, currentValue));
    }
    return value;
  };
  const getEntryOperator = (type, operator) => {
    var _OPERATOR_TYPE_LABELS, _OPERATOR_TYPE_LABELS2;
    if (type === 'nested') return '';
    return operator === 'included' ? (_OPERATOR_TYPE_LABELS = OPERATOR_TYPE_LABELS_INCLUDED[type]) !== null && _OPERATOR_TYPE_LABELS !== void 0 ? _OPERATOR_TYPE_LABELS : type : (_OPERATOR_TYPE_LABELS2 = OPERATOR_TYPE_LABELS_EXCLUDED[type]) !== null && _OPERATOR_TYPE_LABELS2 !== void 0 ? _OPERATOR_TYPE_LABELS2 : type;
  };
  const getNestedEntriesContent = (0, _react.useCallback)((type, nestedEntries) => {
    if (type === 'nested' && nestedEntries.length) {
      return nestedEntries.map(({
        field: nestedField,
        type: nestedType,
        value: nestedValue,
        operator: nestedOperator
      }) => {
        return /*#__PURE__*/_react.default.createElement(EuiFlexGroupNested, {
          "data-test-subj": getTestId('nestedCondition'),
          key: nestedField + nestedType + nestedValue,
          direction: "row",
          alignItems: "center",
          gutterSize: "m",
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
          iconType: "tokenNested",
          size: "s"
        })), /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
          description: '',
          value: nestedField,
          color: "subdued"
        })), /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
          description: getEntryOperator(nestedType, nestedOperator),
          value: getEntryValue(nestedType, nestedValue)
        })));
      });
    }
  }, [getTestId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('os')
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: '',
    value: _translations.CONDITION_OS
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: _translations.CONDITION_OPERATOR_TYPE_MATCH,
    value: osLabel
  }))), entries.map(({
    field,
    type,
    value,
    operator,
    entries: nestedEntries = []
  }) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId('condition'),
      key: field + type + value
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-xScroll"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: /*#__PURE__*/_react.default.createElement(StyledCondition, null, _translations.CONDITION_AND),
      value: field,
      color: "subdued"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: getEntryOperator(type, operator),
      value: getEntryValue(type, value)
    })), getNestedEntriesContent(type, nestedEntries));
  }));
});
exports.CriteriaConditions = CriteriaConditions;
CriteriaConditions.displayName = 'CriteriaConditions';