"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactEntryCardMinified = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _criteria_conditions = require("./components/criteria_conditions");
var _use_normalized_artifact = require("./hooks/use_normalized_artifact");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _translations = require("./components/translations");
var _description_field = require("./components/description_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardContainerPanel = (0, _styledComponents.default)(_eui.EuiSplitPanel.Outer)`
  &.artifactEntryCardMinified + &.artifactEntryCardMinified {
    margin-top: ${({
  theme
}) => theme.eui.euiSizeL};
  }
`;
const CustomSplitInnerPanel = (0, _styledComponents.default)(_eui.EuiSplitPanel.Inner)`
  background-color: ${({
  theme
}) => theme.eui.euiColorLightestShade} !important;
`;
/**
 * Display Artifact Items (ex. Trusted App, Event Filter, etc) as a minified card.
 * This component is a TS Generic that allows you to set what the Item type is
 */
const ArtifactEntryCardMinified = /*#__PURE__*/(0, _react.memo)(({
  item,
  isSelected = false,
  onToggleSelectedArtifact,
  'data-test-subj': dataTestSubj,
  ...commonProps
}) => {
  var _commonProps$classNam;
  const artifact = (0, _use_normalized_artifact.useNormalizedArtifact)(item);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [accordionTrigger, setAccordionTrigger] = (0, _react.useState)('closed');
  const handleOnToggleAccordion = (0, _react.useCallback)(() => {
    setAccordionTrigger(current => current === 'closed' ? 'open' : 'closed');
  }, []);
  const getAccordionTitle = (0, _react.useCallback)(() => accordionTrigger === 'open' ? 'Hide details' : 'Show details', [accordionTrigger]);
  const cardTitle = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(CustomSplitInnerPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: artifact.name,
    "data-test-subj": `${artifact.name}_checkbox`,
    checked: isSelected,
    onChange: () => onToggleSelectedArtifact(!isSelected)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": getTestId('title')
  }, artifact.name))))), [artifact.name, getTestId, isSelected, onToggleSelectedArtifact]);
  return /*#__PURE__*/_react.default.createElement(CardContainerPanel, (0, _extends2.default)({}, commonProps, {
    "data-test-subj": dataTestSubj,
    className: `${(_commonProps$classNam = commonProps.className) !== null && _commonProps$classNam !== void 0 ? _commonProps$classNam : ''}  artifactEntryCardMinified`,
    id: artifact.name,
    hasShadow: false,
    hasBorder: true
  }), cardTitle, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": getTestId('descriptionTitle')
  }, _translations.DESCRIPTION_LABEL)), /*#__PURE__*/_react.default.createElement(_description_field.DescriptionField, {
    "data-test-subj": getTestId('description')
  }, artifact.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": getTestId('collapse'),
    color: "primary",
    size: "s",
    flush: "left",
    iconType: accordionTrigger === 'open' ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    iconSize: "m",
    onClick: handleOnToggleAccordion,
    style: {
      fontWeight: 400
    }
  }, getAccordionTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "showDetails",
    arrowDisplay: "none",
    forceState: accordionTrigger
  }, /*#__PURE__*/_react.default.createElement(_criteria_conditions.CriteriaConditions, {
    os: artifact.os,
    entries: artifact.entries,
    "data-test-subj": getTestId('criteriaConditions')
  })))));
});
exports.ArtifactEntryCardMinified = ArtifactEntryCardMinified;
ArtifactEntryCardMinified.displayName = 'ArtifactEntryCardMinified';