"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchUniqueByField = void 0;
var _reactQuery = require("@tanstack/react-query");
var _fetch_data = require("../utils/fetch_data");
var _kibana = require("../../../common/lib/kibana");
var _build_requests = require("../utils/build_requests");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = 'useFetchUniqueByField';
/**
 * Hook to retrieve all unique documents by field in the environment, using ReactQuery.
 *
 * For example, passing 'host.name' via the field props will return the number of unique hosts in the environment.
 */
const useFetchUniqueByField = ({
  field
}) => {
  const {
    services: {
      data: {
        search: searchService
      }
    }
  } = (0, _kibana.useKibana)();
  const searchRequest = (0, _build_requests.buildAggregationSearchRequest)(field, _fetch_data.AGG_KEY);
  const {
    data,
    isLoading,
    isError
  } = (0, _reactQuery.useQuery)([QUERY_KEY, field], () => (0, _fetch_data.createFetchData)(searchService, searchRequest), {
    select: res => res.aggregations[_fetch_data.AGG_KEY].buckets.length,
    keepPreviousData: true
  });
  return {
    loading: isLoading,
    error: isError,
    count: data || 0
  };
};
exports.useFetchUniqueByField = useFetchUniqueByField;