"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistant = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = require("react");
var _use_assistant_availability = require("../../../assistant/use_assistant_availability");
var _helpers = require("../../../assistant/helpers");
var _translations = require("../../../common/components/event_details/translations");
var _prompt_contexts = require("../../../assistant/content/prompt_contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantNoop = () => ({
  promptContextId: undefined
});
/**
 * Hook to return the assistant button visibility and prompt context id
 */
const useAssistant = ({
  dataFormattedForFieldBrowser,
  isAlert
}) => {
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const useAssistantHook = hasAssistantPrivilege ? _elasticAssistant.useAssistantOverlay : useAssistantNoop;
  const getPromptContext = (0, _react.useCallback)(async () => (0, _helpers.getPromptContextFromEventDetailsItem)(dataFormattedForFieldBrowser !== null && dataFormattedForFieldBrowser !== void 0 ? dataFormattedForFieldBrowser : []), [dataFormattedForFieldBrowser]);
  const {
    promptContextId
  } = useAssistantHook(isAlert ? 'alert' : 'event', isAlert ? _translations.ALERT_SUMMARY_CONVERSATION_ID : _translations.EVENT_SUMMARY_CONVERSATION_ID, isAlert ? (0, _translations.ALERT_SUMMARY_CONTEXT_DESCRIPTION)(_translations.SUMMARY_VIEW) : (0, _translations.EVENT_SUMMARY_CONTEXT_DESCRIPTION)(_translations.SUMMARY_VIEW), getPromptContext, null, isAlert ? _prompt_contexts.PROMPT_CONTEXTS[_prompt_contexts.PROMPT_CONTEXT_ALERT_CATEGORY].suggestedUserPrompt : _prompt_contexts.PROMPT_CONTEXTS[_prompt_contexts.PROMPT_CONTEXT_EVENT_CATEGORY].suggestedUserPrompt, isAlert ? _translations.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP : _translations.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP);
  return {
    showAssistant: hasAssistantPrivilege && promptContextId !== null,
    promptContextId: promptContextId || ''
  };
};
exports.useAssistant = useAssistant;