"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_sync_flyout_state_with_url = require("../../url/use_sync_flyout_state_with_url");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Puts alertUrl to user's clipboard. If current query string contains synced flyout state,
 * it will be appended to the base alertUrl
 */
const ShareButton = ({
  alertUrl
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: alertUrl
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      // NOTE: currently, it is not possible to have textToCopy computed dynamically.
      // so, we are calling copy() here to trigger the ui tooltip, and then override the link manually
      copy();
      const query = new URLSearchParams(window.location.search);
      const alertDetailsLink = `${alertUrl}&${_use_sync_flyout_state_with_url.FLYOUT_URL_PARAM}=${query.get(_use_sync_flyout_state_with_url.FLYOUT_URL_PARAM)}`;
      (0, _eui.copyToClipboard)(alertDetailsLink);
    },
    iconType: "share",
    "data-test-subj": _test_ids.FLYOUT_HEADER_SHARE_BUTTON_TEST_ID
  }, _translations.SHARE));
};
exports.ShareButton = ShareButton;
ShareButton.displayName = 'ShareButton';