"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionPreview = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
var _context = require("../context");
var _formatted_date = require("../../../common/components/formatted_date");
var _use_process_data = require("../hooks/use_process_data");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _left = require("../../left");
var _formatted_field_helpers = require("../../../timelines/components/timeline/body/renderers/formatted_field_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * One-off helper to make sure that inline values are rendered consistently
 */
const ValueContainer = ({
  text,
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement("span", null, text), "\xA0"), children);

/**
 * Renders session preview under visualistions section in the flyout right EuiPanel
 */
const SessionPreview = () => {
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const goToSessionViewTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.LeftPanelKey,
      path: _left.LeftPanelVisualizeTabPath,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    processName,
    userName,
    startAt,
    ruleName,
    ruleId,
    workdir,
    command
  } = (0, _use_process_data.useProcessData)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const emphasisStyles = (0, _react.useMemo)(() => ({
    fontWeight: euiTheme.font.weight.bold
  }), [euiTheme.font.weight.bold]);
  const processNameFragment = (0, _react.useMemo)(() => {
    return processName && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: _translations.SESSION_PREVIEW_PROCESS_TEXT
    }, /*#__PURE__*/_react.default.createElement("span", {
      style: emphasisStyles
    }, processName));
  }, [emphasisStyles, processName]);
  const timeFragment = (0, _react.useMemo)(() => {
    return startAt && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: _translations.SESSION_PREVIEW_TIME_TEXT
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(startAt)
    }));
  }, [startAt]);
  const ruleFragment = (0, _react.useMemo)(() => {
    return ruleName && ruleId && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: _translations.SESSION_PREVIEW_RULE_TEXT
    }, /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
      contextId: scopeId,
      eventId: eventId,
      fieldName: _constants.SIGNAL_RULE_NAME_FIELD_NAME,
      fieldType: 'string',
      isAggregatable: false,
      isDraggable: false,
      linkValue: ruleId,
      value: ruleName
    }));
  }, [ruleName, ruleId, scopeId, eventId]);
  const commandFragment = (0, _react.useMemo)(() => {
    return command && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: _translations.SESSION_PREVIEW_COMMAND_TEXT
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, workdir, " ", command));
  }, [command, workdir]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none",
    "data-test-subj": _test_ids.SESSION_PREVIEW_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconType: "sessionViewer",
    onClick: goToSessionViewTab,
    "data-test-subj": _test_ids.SESSION_PREVIEW_VIEW_DETAILS_BUTTON_TEST_ID
  }, _translations.SESSION_PREVIEW_TITLE), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(ValueContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user"
  }), "\xA0", /*#__PURE__*/_react.default.createElement("span", {
    style: emphasisStyles
  }, userName)), processNameFragment, timeFragment, ruleFragment, commandFragment)));
};
exports.SessionPreview = SessionPreview;