"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceOverviewRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _translations = require("./translations");
var _use_fetch_field_value_pair_with_aggregation = require("../../shared/hooks/use_fetch_field_value_pair_with_aggregation");
var _use_fetch_unique_by_field = require("../../shared/hooks/use_fetch_unique_by_field");
var _insights_summary_row = require("./insights_summary_row");
var _types = require("../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_FIELD = 'host.name';
const PERCENTAGE_THRESHOLD = 0.1; // we show the prevalence if its value is below 10%

/**
 * Retrieves the unique hosts for the field/value pair as well as the total number of unique hosts,
 * calculate the prevalence. If the prevalence is higher than 1, use the callback method to let the parent know
 * the row will render null.
 */
const PrevalenceOverviewRow = ({
  highlightedField,
  scopeId,
  callbackIfNull,
  'data-test-subj': dataTestSubj
}) => {
  const isActiveTimelines = scopeId === _types.TimelineId.active;
  const {
    loading: hostsLoading,
    error: hostsError,
    count: hostsCount
  } = (0, _use_fetch_field_value_pair_with_aggregation.useFetchFieldValuePairWithAggregation)({
    highlightedField,
    isActiveTimelines,
    aggregationField: HOST_FIELD
  });
  const {
    loading: uniqueHostsLoading,
    error: uniqueHostsError,
    count: uniqueHostsCount
  } = (0, _use_fetch_unique_by_field.useFetchUniqueByField)({
    field: HOST_FIELD
  });
  const {
    name,
    values
  } = highlightedField;

  // prevalence is number of host(s) where the field/value pair was found divided by the total number of hosts in the environment
  const prevalence = hostsCount / uniqueHostsCount;
  const loading = hostsLoading || uniqueHostsLoading;
  const error = hostsError || uniqueHostsError;
  const text = `${name}, ${values} ${_translations.PREVALENCE_ROW_UNCOMMON}`;

  // we do not want to render the row is the prevalence is Infinite, 0 or above the decided threshold
  const shouldNotRender = isFinite(prevalence) && (prevalence === 0 || prevalence > PERCENTAGE_THRESHOLD);

  // callback to let the parent component aware of which rows are null (so it can hide itself completely if all are null)
  if (!loading && (error || shouldNotRender)) {
    callbackIfNull();
  }
  return /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: loading,
    error: error || shouldNotRender,
    icon: 'warning',
    text: text,
    "data-test-subj": dataTestSubj
  });
};
exports.PrevalenceOverviewRow = PrevalenceOverviewRow;
PrevalenceOverviewRow.displayName = 'PrevalenceOverviewRow';