"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsSummaryRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _formatted_number = require("../../../common/components/formatted_number");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Panel showing summary information as an icon, a count and text as well as a severity colored dot.
 * Should be used for Entities, Threat Intelligence, Prevalence, Correlations and Results components under the Insights section.
 * The colored dot is currently optional but will ultimately be mandatory (waiting on PM and UIUX).
 */
const InsightsSummaryRow = ({
  loading = false,
  error = false,
  icon,
  value,
  text,
  color,
  'data-test-subj': dataTestSubj
}) => {
  const loadingDataTestSubj = `${dataTestSubj}Loading`;
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      size: "m",
      isLoading: loading,
      contentAriaLabel: "Loading",
      "data-test-subj": loadingDataTestSubj
    });
  }
  if (error) {
    return null;
  }
  const iconDataTestSubj = `${dataTestSubj}Icon`;
  const valueDataTestSubj = `${dataTestSubj}Value`;
  const colorDataTestSubj = `${dataTestSubj}Color`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: 'spaceBetween',
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": iconDataTestSubj,
    "aria-label": 'entity-icon',
    color: "text",
    display: "empty",
    iconType: icon,
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": valueDataTestSubj,
    css: (0, _react2.css)`
          word-break: break-word;
          display: -webkit-box;
          -webkit-line-clamp: 1;
          -webkit-box-orient: vertical;
          overflow: hidden;
        `
  }, value && /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: value
  }), " ", text), color && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": colorDataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color
  })));
};
exports.InsightsSummaryRow = InsightsSummaryRow;
InsightsSummaryRow.displayName = 'InsightsSummaryRow';